/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.core.chart;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.moskito.control.core.Application;
import org.moskito.control.core.accumulator.AccumulatorDataItem;
import org.moskito.control.core.chart.ChartLine;

public class Chart {
    private Application parent;
    private String name;
    private List<ChartLine> lines = new LinkedList();
    private int limit = -1;

    public Chart(Application aParent, String aName, int aLimit) {
        this.name = aName;
        this.parent = aParent;
        this.limit = aLimit;
    }

    public Application getParent() {
        return this.parent;
    }

    public void setParent(Application parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addLine(String component, String accumulator, String caption) {
        this.lines.add(new ChartLine(component, accumulator, caption));
    }

    public void addLine(String component, String accumulator) {
        this.addLine(component, accumulator, null);
    }

    public List<String> getNeededAccumulatorsForComponent(String componentName) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ChartLine line : this.lines) {
            if (!line.getComponent().equals(componentName)) continue;
            ret.add(line.getAccumulator());
        }
        return ret;
    }

    public String toString() {
        return "App: " + this.getParent().getName() + " Chart: " + this.getName();
    }

    public void notifyNewData(String componentName, String accumulatorName, List<AccumulatorDataItem> data) {
        if (this.limit != -1 && data.size() > this.limit) {
            data = data.subList(data.size() - this.limit, data.size());
        }
        for (ChartLine line : this.lines) {
            if (!line.getComponent().equals(componentName) || !line.getAccumulator().equals(accumulatorName)) continue;
            line.setData(data);
        }
    }

    public List<ChartLine> getLines() {
        return this.lines;
    }
}

