/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.core.chart;

import java.util.ArrayList;
import java.util.List;
import org.moskito.control.core.accumulator.AccumulatorDataItem;

public class ChartLine {
    private String component;
    private String accumulator;
    private String chartCaption;
    private List<AccumulatorDataItem> data = new ArrayList();

    public ChartLine(String aComponent, String anAccumulator, String aChartCaption) {
        this.component = aComponent;
        this.accumulator = anAccumulator;
        this.chartCaption = aChartCaption;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(String accumulator) {
        this.accumulator = accumulator;
    }

    public List<AccumulatorDataItem> getData() {
        return this.data;
    }

    public void setData(List<AccumulatorDataItem> data) {
        this.data = data;
    }

    public String getChartCaption() {
        return this.chartCaption != null && this.chartCaption.length() > 0 ? this.chartCaption : this.getAccumulator() + "@" + this.getComponent();
    }

    public void setChartCaption(String chartCaption) {
        this.chartCaption = chartCaption;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getAccumulator()).append("@").append(this.getComponent());
        if (this.chartCaption != null && this.chartCaption.length() > 0) {
            ret.append(" as ").append(this.chartCaption).append(" ");
        }
        ret.append("with ").append(this.data == null ? "none" : "" + this.data.size()).append(" elements.");
        return ret.toString();
    }
}

