/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.core.notification;

import org.moskito.control.core.ApplicationRepository;
import org.moskito.control.core.notification.StatusChangeMailNotifier;
import org.moskito.control.core.status.StatusChangeEvent;
import org.moskito.control.core.status.StatusChangeListener;
import org.moskito.control.core.util.Muter;
import org.moskito.control.mail.MailService;
import org.moskito.control.mail.MailServiceConfig;
import org.moskito.control.mail.message.MailMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class StatusChangeMailNotifier
implements StatusChangeListener {
    private static Logger log = LoggerFactory.getLogger(StatusChangeMailNotifier.class);
    private Muter muter = new Muter();

    private StatusChangeMailNotifier() {
        ApplicationRepository.getInstance().addStatusChangeListener((StatusChangeListener)this);
    }

    public static StatusChangeMailNotifier getInstance() {
        return StatusChangeMailNotifierInstanceHolder.access$000();
    }

    public void notifyStatusChange(StatusChangeEvent event) {
        log.debug("Processing status change event: " + event);
        if (this.muter.isMuted()) {
            log.debug("Mail notifications are muted. Skipped notification mail sending for status change event " + event + ". Remaining muting time: " + this.getRemainingMutingTime());
            return;
        }
        MailService.getInstance().send(MailMessageBuilder.buildStatusChangedMessage((StatusChangeEvent)event, (String)MailServiceConfig.getInstance().getRecipient()));
        log.debug("Notification mail was send for status change event: " + event);
    }

    public void mute(long delay) {
        this.muter.mute(delay);
        log.debug("Status change mail notifications muted for delay: " + delay);
    }

    public void unmute() {
        this.muter.unmute();
    }

    public boolean isMuted() {
        return this.muter.isMuted();
    }

    public long getRemainingMutingTime() {
        return this.muter.getRemainingTime();
    }
}

