/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.core.updater;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.moskito.control.config.MoskitoControlConfiguration;
import org.moskito.control.config.UpdaterConfig;
import org.moskito.control.connectors.response.ConnectorResponse;
import org.moskito.control.core.Application;
import org.moskito.control.core.ApplicationRepository;
import org.moskito.control.core.Component;
import org.moskito.control.core.updater.AbstractUpdater;
import org.moskito.control.core.updater.ApplicationStatusUpdater;
import org.moskito.control.core.updater.ExecutorStatus;
import org.moskito.control.core.updater.UpdaterStatus;
import org.moskito.control.core.updater.UpdaterTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractUpdater<T extends ConnectorResponse> {
    private MoskitoControlConfiguration configuration = MoskitoControlConfiguration.getConfiguration();
    private static Logger log = LoggerFactory.getLogger(ApplicationStatusUpdater.class);
    private Thread triggerThread;
    private AtomicBoolean updateInProgressFlag = new AtomicBoolean(false);
    private ConcurrentMap<String, UpdaterTask> currentlyExecutedTasks = new ConcurrentHashMap();
    private final ExecutorService updaterService;
    private final ExecutorService connectorService;
    private int lastNumberOfAppToUpdate = 0;

    protected AbstractUpdater() {
        this.triggerThread = new Thread((Runnable)new UpdateTrigger(this));
        this.triggerThread.setDaemon(true);
        if (this.getUpdaterConfig().isEnabled()) {
            this.triggerThread.start();
        } else {
            log.warn("Updater (" + this.getClass().getSimpleName() + ") disabled via config.");
        }
        this.updaterService = Executors.newFixedThreadPool(this.getUpdaterConfig().getThreadPoolSize());
        this.connectorService = Executors.newFixedThreadPool(this.getUpdaterConfig().getThreadPoolSize());
    }

    abstract UpdaterConfig getUpdaterConfig();

    protected MoskitoControlConfiguration getConfiguration() {
        return this.configuration;
    }

    protected abstract UpdaterTask createTask(Application var1, Component var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerUpdate() {
        this.printInfoAboutExecutorService("updater", (ThreadPoolExecutor)this.updaterService);
        this.printInfoAboutExecutorService("connector", (ThreadPoolExecutor)this.connectorService);
        if (this.updateInProgressFlag.get()) {
            log.warn("Previous update isn't finished, skipping.");
            return;
        }
        this.updateInProgressFlag.set(true);
        try {
            int numberOfAppsForUpdate = 0;
            List applications = ApplicationRepository.getInstance().getApplications();
            for (Application app : applications) {
                List components = app.getComponents();
                for (Component c : components) {
                    log.debug("Have to update " + app + " - " + c);
                    ++numberOfAppsForUpdate;
                    UpdaterTask task = this.createTask(app, c);
                    String taskKey = task.getKey();
                    if (this.currentlyExecutedTasks.get(taskKey) != null) {
                        log.warn("UpdaterTask for key " + taskKey + " and task: " + task + " still running, skipped.");
                        continue;
                    }
                    log.debug("Submitting check for " + taskKey + " for execution");
                    this.updaterService.execute((Runnable)task);
                }
            }
            if (numberOfAppsForUpdate != this.lastNumberOfAppToUpdate) {
                this.lastNumberOfAppToUpdate = numberOfAppsForUpdate;
                if (numberOfAppsForUpdate > this.configuration.getStatusUpdater().getThreadPoolSize()) {
                    log.warn("Number of apps to update is larger than available threads, consider increasing thread count " + numberOfAppsForUpdate + " > " + this.configuration.getStatusUpdater().getThreadPoolSize());
                }
            }
        }
        finally {
            this.updateInProgressFlag.set(false);
        }
    }

    protected Future<T> submit(Callable task) {
        return this.connectorService.submit(task);
    }

    public void printInfoAboutExecutorService(String poolName, ThreadPoolExecutor executor) {
    }

    public UpdaterStatus getStatus() {
        UpdaterStatus status = new UpdaterStatus();
        status.setUpdateInProgress(this.updateInProgressFlag.get());
        status.setConnectorStatus(this.getExecutorStatus((ThreadPoolExecutor)this.connectorService));
        status.setUpdaterStatus(this.getExecutorStatus((ThreadPoolExecutor)this.updaterService));
        return status;
    }

    private ExecutorStatus getExecutorStatus(ThreadPoolExecutor executor) {
        ExecutorStatus ret = new ExecutorStatus();
        if (executor == null) {
            ret.setPoolSize(-1L);
            return ret;
        }
        ret.setActiveCount((long)executor.getActiveCount());
        ret.setTaskCount(executor.getTaskCount());
        ret.setCompletedTaskCount(executor.getCompletedTaskCount());
        ret.setPoolSize((long)executor.getPoolSize());
        return ret;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(AbstractUpdater x0) {
        x0.triggerUpdate();
    }
}

