/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import org.moskito.control.mail.MailService;
import org.moskito.control.mail.MailServiceConfig;
import org.moskito.control.mail.message.MailMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailService {
    private static Logger log = LoggerFactory.getLogger(MailService.class);
    private Session mailSession;
    private MailServiceConfig config;
    private static MailService instance = new MailService();

    private MailService() {
        Properties props = new Properties();
        this.config = MailServiceConfig.getInstance();
        props.put("mail.smtp.host", this.config.getHost());
        props.put("mail.smtp.auth", "true");
        props.put("mail.debug", (Object)this.config.isDebug());
        this.mailSession = Session.getInstance((Properties)props, (Authenticator)new SMTPAuthenticator(this, null));
        this.mailSession.setDebug(this.config.isDebug());
    }

    public static MailService getInstance() {
        return instance;
    }

    public boolean send(MailMessage message) {
        try {
            Transport.send((Message)message.transformToMessage(this.mailSession));
        }
        catch (AddressException e) {
            log.error("deliverMailMessage message :{" + message.toString() + "}", (Throwable)e);
        }
        catch (MessagingException e) {
            log.error("deliverMailMessage message :{" + message.toString() + "}", (Throwable)e);
        }
        return true;
    }

    static /* synthetic */ MailServiceConfig access$100(MailService x0) {
        return x0.config;
    }
}

