/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.mail.message;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailMessage
implements Serializable {
    private static final long serialVersionUID = 3390064209846182165L;
    private String encoding;
    private String sender;
    private String senderName = null;
    private String subject;
    private String message;
    private String recipient;
    private Map<String, String> headers = new HashMap();

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Message transformToMessage(Session session) throws MessagingException {
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.sender));
        InternetAddress receiver = new InternetAddress(this.recipient);
        msg.setRecipient(Message.RecipientType.TO, (Address)receiver);
        msg.setContent((Object)(this.message != null ? this.message : ""), this.encoding);
        msg.setSubject(this.subject != null ? this.subject : "");
        this.addHeadersToMessage((Message)msg);
        return msg;
    }

    private void addHeadersToMessage(Message msg) throws MessagingException {
        Set allHeaders = this.headers.keySet();
        for (String key : allHeaders) {
            String val = (String)this.headers.get(key);
            msg.addHeader(key, val);
        }
    }
}

