/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.ui.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.maf.bean.FormBean;
import net.anotheria.util.Date;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.StringUtils;
import net.anotheria.util.TimeUnit;
import net.anotheria.util.sorter.DummySortType;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import org.moskito.control.config.MoskitoControlConfiguration;
import org.moskito.control.core.Application;
import org.moskito.control.core.ApplicationRepository;
import org.moskito.control.core.Component;
import org.moskito.control.core.accumulator.AccumulatorDataItem;
import org.moskito.control.core.chart.Chart;
import org.moskito.control.core.chart.ChartLine;
import org.moskito.control.core.history.StatusUpdateHistoryItem;
import org.moskito.control.core.history.StatusUpdateHistoryRepository;
import org.moskito.control.core.notification.StatusChangeMailNotifier;
import org.moskito.control.core.threshold.ThresholdDataItem;
import org.moskito.control.ui.action.BaseMoSKitoControlAction;
import org.moskito.control.ui.bean.ApplicationBean;
import org.moskito.control.ui.bean.CategoryBean;
import org.moskito.control.ui.bean.ChartBean;
import org.moskito.control.ui.bean.ChartPointBean;
import org.moskito.control.ui.bean.ComponentBean;
import org.moskito.control.ui.bean.ComponentCountAndStatusByCategoryBean;
import org.moskito.control.ui.bean.ComponentCountByHealthStatusBean;
import org.moskito.control.ui.bean.ComponentHolderBean;
import org.moskito.control.ui.bean.HistoryItemBean;
import org.moskito.control.ui.bean.ReferencePoint;
import org.moskito.control.ui.bean.ThresholdBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MainViewAction
extends BaseMoSKitoControlAction {
    private static Logger log = LoggerFactory.getLogger(MainViewAction.class);

    public ActionCommand execute(ActionMapping actionMapping, FormBean formBean, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ApplicationRepository repository = ApplicationRepository.getInstance();
        List applications = repository.getApplications();
        ArrayList<ApplicationBean> applicationBeans = new ArrayList<ApplicationBean>();
        String currentApplicationName = this.getCurrentApplicationName(httpServletRequest);
        if (currentApplicationName == null) {
            currentApplicationName = MoskitoControlConfiguration.getConfiguration().getDefaultApplication();
        }
        if (currentApplicationName == null && applications.size() == 1) {
            currentApplicationName = ((Application)applications.get(0)).getName();
        }
        for (Application app : applications) {
            ApplicationBean bean = new ApplicationBean();
            bean.setName(app.getName());
            bean.setColor(app.getWorstHealthStatus().toString().toLowerCase());
            if (app.getName().equals(currentApplicationName)) {
                bean.setActive(true);
            }
            applicationBeans.add(bean);
        }
        httpServletRequest.setAttribute("applications", applicationBeans);
        ComponentCountByHealthStatusBean countByStatusBean = new ComponentCountByHealthStatusBean();
        ComponentCountAndStatusByCategoryBean countByCategoryBean = new ComponentCountAndStatusByCategoryBean();
        Application current = repository.getApplication(currentApplicationName);
        if (current != null) {
            httpServletRequest.setAttribute("tvStatus", (Object)current.getWorstHealthStatus().toString().toLowerCase());
        } else {
            httpServletRequest.setAttribute("tvStatus", (Object)"none");
        }
        List categoryBeans = Collections.emptyList();
        ArrayList<ComponentHolderBean> holders = new ArrayList<ComponentHolderBean>();
        if (current != null) {
            String selectedCategory = this.getCurrentCategoryName(httpServletRequest);
            if (selectedCategory == null) {
                selectedCategory = "";
            }
            List components = current.getComponents();
            for (Component c : components) {
                countByCategoryBean.processComponent(c);
            }
            categoryBeans = countByCategoryBean.getCategoryBeans();
            CategoryBean allCategory = (CategoryBean)categoryBeans.get(0);
            allCategory.setSelected(true);
            if (selectedCategory != null && selectedCategory.length() != 0) {
                for (CategoryBean cb : categoryBeans) {
                    if (!cb.getName().equals(selectedCategory)) continue;
                    allCategory.setSelected(false);
                    cb.setSelected(true);
                }
            }
            HashMap componentsByCategories = new HashMap();
            HashMap<String, CategoryBean> categoriesByCategoryNames = new HashMap<String, CategoryBean>();
            for (CategoryBean categoryBean : categoryBeans) {
                if (categoryBean.isAll()) continue;
                componentsByCategories.put(categoryBean.getName(), new ArrayList());
                categoriesByCategoryNames.put(categoryBean.getName(), categoryBean);
            }
            for (Component component : components) {
                if (selectedCategory.length() != 0 && !selectedCategory.equals(component.getCategory())) continue;
                countByStatusBean.addColor(component.getHealthColor());
                ComponentBean cBean = new ComponentBean();
                cBean.setName(component.getName());
                cBean.setColor(component.getHealthColor().toString().toLowerCase());
                cBean.setMessages(component.getStatus().getMessages());
                cBean.setUpdateTimestamp(NumberUtils.makeISO8601TimestampString((long)component.getLastUpdateTimestamp()));
                List tdiList = component.getThresholds();
                ArrayList<ThresholdBean> tBeans = new ArrayList<ThresholdBean>();
                for (ThresholdDataItem tdi : tdiList) {
                    ThresholdBean tBean = new ThresholdBean();
                    tBean.setName(tdi.getName());
                    tBean.setStatus(tdi.getStatus().toString().toLowerCase());
                    tBean.setLastValue(tdi.getLastValue());
                    tBean.setStatusChangeTimestamp(NumberUtils.makeISO8601TimestampString((long)tdi.getStatusChangeTimestamp()));
                    tBeans.add(tBean);
                }
                cBean.setThresholds(tBeans);
                ((List)componentsByCategories.get(component.getCategory())).add(cBean);
            }
            for (Map.Entry entry : componentsByCategories.entrySet()) {
                if (((List)entry.getValue()).size() == 0) continue;
                ComponentHolderBean holderBean = new ComponentHolderBean();
                holderBean.setComponents((List)entry.getValue());
                holderBean.setCategory((CategoryBean)categoriesByCategoryNames.get(entry.getKey()));
                holders.add(holderBean);
            }
        }
        httpServletRequest.setAttribute("countByStatus", (Object)countByStatusBean);
        httpServletRequest.setAttribute("categories", categoryBeans);
        httpServletRequest.setAttribute("componentHolders", holders);
        this.isStatusOn(httpServletRequest);
        if (currentApplicationName != null && currentApplicationName.length() > 0 && this.isHistoryOn(httpServletRequest)) {
            List historyItems = StatusUpdateHistoryRepository.getInstance().getHistoryForApplication(currentApplicationName);
            LinkedList<HistoryItemBean> historyItemBeans = new LinkedList<HistoryItemBean>();
            for (StatusUpdateHistoryItem hi : historyItems) {
                HistoryItemBean bean = new HistoryItemBean();
                bean.setTime(NumberUtils.makeISO8601TimestampString((long)hi.getTimestamp()));
                bean.setComponentName(hi.getComponent().getName());
                bean.setNewStatus(hi.getNewStatus().getHealth().name().toLowerCase());
                bean.setOldStatus(hi.getOldStatus().getHealth().name().toLowerCase());
                historyItemBeans.add(bean);
            }
            httpServletRequest.setAttribute("historyItems", historyItemBeans);
        }
        if (currentApplicationName != null && currentApplicationName.length() > 0 && this.areChartsOn(httpServletRequest)) {
            this.prepareCharts(current, httpServletRequest);
        }
        String lastRefreshTimestamp = NumberUtils.makeISO8601TimestampString();
        httpServletRequest.setAttribute("lastRefreshTimestamp", (Object)lastRefreshTimestamp);
        httpServletRequest.setAttribute("configuration", (Object)MoskitoControlConfiguration.getConfiguration());
        httpServletRequest.setAttribute("notificationsMuted", (Object)StatusChangeMailNotifier.getInstance().isMuted());
        httpServletRequest.setAttribute("notificationsMutingTime", (Object)MoskitoControlConfiguration.getConfiguration().getNotificationsMutingTime());
        long remainingTime = StatusChangeMailNotifier.getInstance().getRemainingMutingTime();
        httpServletRequest.setAttribute("notificationsRemainingMutingTime", (Object)(remainingTime <= 0L ? "0" : BigDecimal.valueOf((float)remainingTime / 60000.0f).setScale(1, RoundingMode.UP).toString()));
        return actionMapping.success();
    }

    private static void prepareReferenceLineAndAdoptChart(Chart chart) {
        List lines = chart.getLines();
        try {
            long minDistance = Long.MAX_VALUE;
            long maxDistance = 0L;
            List items = ((ChartLine)lines.get(0)).getData();
            long previous = ((AccumulatorDataItem)items.get(0)).getTimestamp();
            for (int i = 1; i < items.size(); ++i) {
                long distance = ((AccumulatorDataItem)items.get(i)).getTimestamp() - previous;
                if (distance > maxDistance) {
                    maxDistance = distance;
                }
                if (distance < minDistance) {
                    minDistance = distance;
                }
                previous = ((AccumulatorDataItem)items.get(i)).getTimestamp();
            }
            if (minDistance > TimeUnit.MINUTE.getMillis(2)) {
                ArrayList<ReferencePoint> referenceLine = new ArrayList<ReferencePoint>(items.size());
                for (AccumulatorDataItem item : items) {
                    referenceLine.add(new ReferencePoint(item.getTimestamp()));
                }
                for (int i = 1; i < lines.size(); ++i) {
                    List linesItems = ((ChartLine)lines.get(i)).getData();
                    block5: for (AccumulatorDataItem linesItem : linesItems) {
                        for (ReferencePoint rp : referenceLine) {
                            if (!rp.isInRange(linesItem.getTimestamp(), minDistance)) continue;
                            linesItem.setTimestamp(rp.getTimestamp());
                            continue block5;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void prepareCharts(Application current, HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("chartBeans", (Object)MainViewAction.prepareChartData((Application)current));
    }

    public static List<ChartBean> prepareChartData(Application current) {
        List charts = current.getCharts();
        LinkedList<ChartBean> beans = new LinkedList<ChartBean>();
        for (Chart chart : charts) {
            ChartBean bean = new ChartBean();
            bean.setDivId(StringUtils.normalize((String)chart.getName()));
            bean.setName(chart.getName());
            HashMap<String, ChartPointBean> points = new HashMap<String, ChartPointBean>();
            List lines = chart.getLines();
            MainViewAction.prepareReferenceLineAndAdoptChart((Chart)chart);
            int lastHour = 0;
            for (ChartLine l1 : lines) {
                List items = l1.getData();
                for (AccumulatorDataItem item : items) {
                    String fdCaption = item.getFullDateCaption();
                    ChartPointBean point = (ChartPointBean)points.get(fdCaption);
                    Date currentDate = new Date(item.getTimestamp());
                    int currentHour = currentDate.getHour();
                    if (point == null) {
                        String captionForThePoint = item.getCaption();
                        if (currentHour < lastHour) {
                            captionForThePoint = NumberUtils.itoa((int)currentDate.getDay(), (int)2) + "." + NumberUtils.itoa((int)currentDate.getMonth(), (int)2) + " " + captionForThePoint;
                        }
                        point = new ChartPointBean(captionForThePoint, item.getTimestamp());
                        points.put(fdCaption, point);
                    }
                    lastHour = currentHour;
                }
            }
            int currentLineCount = 0;
            int skipCount = 0;
            int presentCount = 0;
            for (ChartLine l : lines) {
                if (l.getData().size() == 0) {
                    log.warn("Got no data for chart: " + chart.getName() + ", line: " + l.getChartCaption() + ", remove it from chart");
                    continue;
                }
                ++currentLineCount;
                bean.addLineName(l.getChartCaption());
                HashSet<String> alreadyDone = new HashSet<String>();
                List items = l.getData();
                for (AccumulatorDataItem item : items) {
                    String fdCaption = item.getFullDateCaption();
                    if (alreadyDone.contains(fdCaption)) {
                        log.warn("Skipped item " + item + " because it resolves to a already used caption " + fdCaption + " in line " + l + " chart " + chart + skipCount++);
                        continue;
                    }
                    ++presentCount;
                    ChartPointBean point = (ChartPointBean)points.get(fdCaption);
                    point.addValue(item.getValue());
                    alreadyDone.add(fdCaption);
                }
                for (ChartPointBean point : points.values()) {
                    point.ensureLength(currentLineCount);
                }
            }
            Collection calculatedPoints = points.values();
            List sortedPoints = StaticQuickSorter.sort(calculatedPoints, (SortType)new DummySortType());
            if (sortedPoints.size() > 0) {
                boolean emptyValuesPresent = true;
                int numberOfValues = ((ChartPointBean)sortedPoints.get(0)).getValues().size();
                while (emptyValuesPresent) {
                    emptyValuesPresent = false;
                    for (int i = 0; i < sortedPoints.size(); ++i) {
                        ChartPointBean b = (ChartPointBean)sortedPoints.get(i);
                        for (int v = 0; v < numberOfValues; ++v) {
                            if (!b.isEmptyValueAt(v) || ((ChartLine)chart.getLines().get(v)).getData().size() <= 0) continue;
                            emptyValuesPresent = true;
                            if (i == 0 || ((ChartPointBean)sortedPoints.get(i - 1)).isEmptyValueAt(v)) {
                                if (sortedPoints.size() == 1) {
                                    b.setValueAt(v, "0");
                                    continue;
                                }
                                try {
                                    if (i == sortedPoints.size() - 1) {
                                        b.setValueAt(v, ((ChartPointBean)sortedPoints.get(i - 1)).getValueAt(v));
                                        continue;
                                    }
                                    b.setValueAt(v, ((ChartPointBean)sortedPoints.get(i + 1)).getValueAt(v));
                                }
                                catch (Exception e) {
                                    log.warn("unexpected chart problem: " + e.getMessage() + " v: " + v + ", i: " + i + " - sortedPoints: " + sortedPoints.size() + " numberOfValues: " + numberOfValues + ", chart: " + chart.getName());
                                }
                                continue;
                            }
                            b.setValueAt(v, ((ChartPointBean)sortedPoints.get(i - 1)).getValueAt(v));
                        }
                    }
                }
            }
            bean.setPoints(sortedPoints);
            beans.add(bean);
        }
        return beans;
    }
}

