/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.ui.bean;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.anotheria.util.BasicComparable;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.sorter.IComparable;

@XmlRootElement
public class ChartPointBean
implements IComparable {
    public static final String TEMPORARLY_FILL_OUT_STRING = "XXX";
    @XmlElement
    private String caption;
    @XmlElement
    private List<String> values = new ArrayList();
    @XmlElement
    private long timestamp;

    public ChartPointBean(String aCaption, long aTimestamp) {
        this.caption = aCaption;
        this.timestamp = aTimestamp;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void ensureLength(int currentLineCount) {
        while (this.values.size() < currentLineCount) {
            this.values.add(TEMPORARLY_FILL_OUT_STRING);
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("[");
        ret.append("\"").append(this.caption).append("\"");
        for (String s : this.values) {
            ret.append(",").append(s);
        }
        ret.append("]");
        return ret.toString();
    }

    public int compareTo(IComparable iComparable, int i) {
        return BasicComparable.compareLong((long)this.timestamp, (long)((ChartPointBean)iComparable).timestamp);
    }

    public boolean isEmptyValueAt(int v) {
        return ((String)this.values.get(v)).equals(TEMPORARLY_FILL_OUT_STRING);
    }

    public void setValueAt(int v, String s) {
        this.values.set(v, s);
    }

    public String getValueAt(int v) {
        return (String)this.values.get(v);
    }

    public String getCaption() {
        return this.caption;
    }

    @XmlElement(name="debugTs")
    public String getDebugTimestamp() {
        return NumberUtils.makeISO8601TimestampString((long)this.timestamp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

