/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.ui.resource;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.moskito.control.core.Application;
import org.moskito.control.core.ApplicationRepository;
import org.moskito.control.ui.action.MainViewAction;
import org.moskito.control.ui.bean.ChartPointBean;
import org.moskito.control.ui.resource.ChartBean;
import org.moskito.control.ui.resource.ChartContainerBean;
import org.moskito.control.ui.resource.ChartLineBean;
import org.moskito.control.ui.resource.ChartLinesBean;

@Path(value="/charts")
@Produces(value={"application/json"})
public class ChartResource {
    @GET
    @Path(value="/points/{appName}")
    public ChartContainerBean chartPoints(@PathParam(value="appName") String appName) {
        Application app = ApplicationRepository.getInstance().getApplication(appName);
        if (app == null) {
            throw new IllegalArgumentException("Couldn't find application for " + appName);
        }
        ChartContainerBean ret = new ChartContainerBean();
        List viewBeans = MainViewAction.prepareChartData((Application)app);
        ArrayList<ChartBean> restBeans = new ArrayList<ChartBean>();
        for (org.moskito.control.ui.bean.ChartBean viewCB : viewBeans) {
            ChartBean restCB = new ChartBean();
            restCB.setLineNames(viewCB.getLineNames());
            restCB.setPoints(viewCB.getPoints());
            restCB.setName(viewCB.getName());
            restBeans.add(restCB);
        }
        ret.setCharts(restBeans);
        return ret;
    }

    @GET
    @Path(value="/lines/{appName}")
    public ChartContainerBean chartLines(@PathParam(value="appName") String appName) {
        Application app = ApplicationRepository.getInstance().getApplication(appName);
        if (app == null) {
            throw new IllegalArgumentException("Couldn't find application for " + appName);
        }
        ChartContainerBean ret = new ChartContainerBean();
        List viewBeans = MainViewAction.prepareChartData((Application)app);
        ArrayList<ChartLinesBean> restBeans = new ArrayList<ChartLinesBean>();
        for (org.moskito.control.ui.bean.ChartBean viewCB : viewBeans) {
            ChartLinesBean restCB = new ChartLinesBean();
            restCB.setName(viewCB.getName());
            for (int i = 0; i < viewCB.getLineNames().size(); ++i) {
                ChartLineBean chartLineBean = new ChartLineBean();
                chartLineBean.setLineName((String)viewCB.getLineNames().get(i));
                restCB.addChartLineBean(chartLineBean);
            }
            int l = viewCB.getLineNames().size();
            for (int i = 0; i < viewCB.getPoints().size(); ++i) {
                ChartPointBean cpb = (ChartPointBean)viewCB.getPoints().get(i);
                restCB.addCaption(cpb.getCaption());
                restCB.addTimestamp(cpb.getTimestamp());
                for (int t = 0; t < l; ++t) {
                    ((ChartLineBean)restCB.getLines().get(t)).addValue(cpb.getValueAt(t));
                }
            }
            restBeans.add(restCB);
        }
        ret.setCharts(restBeans);
        return ret;
    }
}

