/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.ui.resource;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.moskito.control.core.Application;
import org.moskito.control.core.ApplicationRepository;
import org.moskito.control.core.Component;
import org.moskito.control.ui.resource.ApplicationContainerBean;
import org.moskito.control.ui.resource.ComponentBean;
import org.moskito.control.ui.resource.ControlBean;

@Path(value="/control")
@Produces(value={"application/json"})
public class ControlResource {
    @GET
    @Produces(value={"application/json"})
    public ControlBean control() {
        ControlBean ret = new ControlBean();
        ApplicationRepository repository = ApplicationRepository.getInstance();
        List applications = repository.getApplications();
        for (Application application : applications) {
            ApplicationContainerBean acb = new ApplicationContainerBean();
            acb.setName(application.getName());
            acb.setApplicationColor(application.getWorstHealthStatus());
            List components = application.getComponents();
            for (Component c : components) {
                ComponentBean cBean = new ComponentBean();
                cBean.setName(c.getName());
                cBean.setColor(c.getHealthColor());
                cBean.setCategory(c.getCategory());
                cBean.setMessages(c.getStatus().getMessages());
                cBean.setLastUpdateTimestamp(c.getLastUpdateTimestamp());
                acb.addComponent(cBean);
            }
            ret.addApplication(acb);
        }
        return ret;
    }
}

