/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.ui.resource;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import net.anotheria.util.NumberUtils;
import org.moskito.control.core.history.StatusUpdateHistoryItem;
import org.moskito.control.core.history.StatusUpdateHistoryRepository;
import org.moskito.control.ui.resource.HistoryBean;
import org.moskito.control.ui.resource.HistoryItemBean;

@Path(value="/history/{appName}")
public class HistoryResource {
    @GET
    @Produces(value={"application/json"})
    public HistoryBean control(@PathParam(value="appName") String appName) {
        ArrayList<HistoryItemBean> beans = new ArrayList<HistoryItemBean>();
        List items = StatusUpdateHistoryRepository.getInstance().getHistoryForApplication(appName);
        if (items == null) {
            return new HistoryBean(appName, beans);
        }
        for (StatusUpdateHistoryItem item : items) {
            HistoryItemBean b = new HistoryItemBean();
            b.setComponentName(item.getComponent().getName());
            b.setIsoTimestamp(NumberUtils.makeISO8601TimestampString((long)item.getTimestamp()));
            b.setTimestamp(item.getTimestamp());
            b.setOldStatus(item.getOldStatus().getHealth().name());
            b.setNewStatus(item.getNewStatus().getHealth().name());
            b.setOldMessages(item.getOldStatus().getMessages());
            b.setNewMessages(item.getNewStatus().getMessages());
            beans.add(b);
        }
        return new HistoryBean(appName, beans);
    }
}

