/*
 * Decompiled with CFR 0.152.
 */
package org.moe;

import apple.NSObject;
import apple.foundation.NSNotificationCenter;
import apple.uikit.c.UIKit;
import java.lang.ref.WeakReference;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.Owned;
import org.moe.natj.general.ann.Runtime;
import org.moe.natj.objc.ObjCRuntime;
import org.moe.natj.objc.SEL;
import org.moe.natj.objc.ann.Selector;

@Runtime(value=ObjCRuntime.class)
public class GCUtil
extends NSObject {
    public static void register() {
        if (Holder.INSTANCE == null) {
            throw new RuntimeException("Failed to create GCUtil");
        }
    }

    protected GCUtil(Pointer peer) {
        super(peer);
    }

    @Owned
    @Selector(value="alloc")
    public static native GCUtil alloc();

    @Override
    @Owned
    @Selector(value="init")
    public GCUtil init() {
        GCUtil self = (GCUtil)super.init();
        if (self != null) {
            NSNotificationCenter center = NSNotificationCenter.defaultCenter();
            center.addObserverSelectorNameObject(self, new SEL("willResignActive"), UIKit.UIApplicationWillResignActiveNotification(), null);
            center.addObserverSelectorNameObject(self, new SEL("didReceiveMemoryWarning"), UIKit.UIApplicationDidReceiveMemoryWarningNotification(), null);
        }
        return self;
    }

    @Selector(value="willResignActive")
    private void willResignActive() {
        GCUtil.gc();
    }

    @Selector(value="didReceiveMemoryWarning")
    private void didReceiveMemoryWarning() {
        GCUtil.gc();
    }

    public static void gc() {
        Object obj = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(obj);
        obj = null;
        while (ref.get() != null) {
            java.lang.Runtime.getRuntime().gc();
        }
        java.lang.Runtime.getRuntime().runFinalization();
    }

    public static void delayedGC() {
        GCUtil.delayedGC(1000L);
    }

    public static void delayedGC(final long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(millis);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                GCUtil.gc();
            }
        }).start();
    }

    static {
        NatJ.register();
    }

    private static class Holder {
        private static final GCUtil INSTANCE = GCUtil.alloc().init();

        private Holder() {
        }
    }
}

