/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.map;

import java.lang.reflect.Constructor;
import org.moe.natj.c.CRuntime;
import org.moe.natj.c.OpaquePtr;
import org.moe.natj.general.Mapper;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.ReferenceInfo;
import org.moe.natj.general.ptr.ConstPtr;
import org.moe.natj.general.ptr.ConstVoidPtr;
import org.moe.natj.general.ptr.impl.PtrImplementer;

public class ReferenceMapper
implements Mapper {
    @Override
    public long toNative(Object instance, NatJ.NativeObjectConstructionInfo info) {
        if (instance == null) {
            return 0L;
        }
        return ((ConstVoidPtr)instance).getPeer().getPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toJava(long peer, NatJ.JavaObjectConstructionInfo info) {
        if (peer == 0L) {
            return null;
        }
        Pointer pointer = CRuntime.createStrongPointer(peer, info.owned);
        try {
            NatJ.JavaObjectConstructionInfo javaObjectConstructionInfo = info;
            synchronized (javaObjectConstructionInfo) {
                Object[] localData = (Object[])info.data;
                if (localData[0] == null) {
                    Constructor<?> constructor;
                    if (localData[1] == null) {
                        localData[1] = OpaquePtr.class.isAssignableFrom(info.type) ? (constructor = this.getOpaqueConstructor(info.type, Pointer.class)) : (constructor = this.getSimpleConstructor(info.type, Pointer.class));
                    } else {
                        constructor = (Constructor<?>)localData[1];
                    }
                    return constructor.newInstance(pointer);
                }
                if (localData[0] instanceof ReferenceInfo) {
                    ReferenceInfo inf = (ReferenceInfo)localData[0];
                    if (inf.depth() == 1) {
                        Constructor<?> constructor;
                        if (localData[1] == null) {
                            localData[1] = constructor = this.getConstructor(inf, info.type, Class.class, Pointer.class);
                        } else {
                            constructor = (Constructor<?>)localData[1];
                        }
                        return constructor.newInstance(inf.type(), pointer);
                    }
                    if (inf.depth() > 1) {
                        Constructor<?> constructor;
                        if (localData[1] == null) {
                            localData[1] = constructor = this.getConstructor(inf, info.type, Class.class, Integer.TYPE, Pointer.class);
                        } else {
                            constructor = (Constructor<?>)localData[1];
                        }
                        return constructor.newInstance(inf.type(), inf.depth(), pointer);
                    }
                    throw new RuntimeException("Invalid reference depth!");
                }
                if (localData[0] instanceof Class) {
                    Constructor<?> constructor;
                    if (localData[1] == null) {
                        localData[1] = constructor = this.getConstructor(null, info.type, Class.class, Pointer.class);
                    } else {
                        constructor = (Constructor<?>)localData[1];
                    }
                    return constructor.newInstance(localData[0], pointer);
                }
            }
            throw new RuntimeException("Invalid local mapper cache!");
        }
        catch (Exception ex) {
            throw new RuntimeException("Java reference construction error!", ex);
        }
    }

    private Constructor<?> getSimpleConstructor(Class<?> type, Class<?> ... args) throws SecurityException, NoSuchMethodException {
        Class<?> impl = PtrImplementer.primitivePtrTypeMap.get(type);
        if (impl == null) {
            throw new RuntimeException("No matching type found in ptr mapper");
        }
        Constructor<?> constructor = impl.getDeclaredConstructor(args);
        constructor.setAccessible(true);
        return constructor;
    }

    private Constructor<?> getConstructor(ReferenceInfo info, Class<?> type, Class<?> ... args) throws SecurityException, NoSuchMethodException {
        Class<?> impl = PtrImplementer.getImplementer(info, type == ConstPtr.class);
        if (impl == null) {
            throw new RuntimeException("No matching type found in ptr mapper");
        }
        Constructor<?> constructor = impl.getDeclaredConstructor(args);
        constructor.setAccessible(true);
        return constructor;
    }

    private Constructor<?> getOpaqueConstructor(Class<?> type, Class<?> ... args) throws SecurityException, NoSuchMethodException {
        Class<?> impl = null;
        for (Class<?> declared : type.getDeclaredClasses()) {
            if (!"Impl".equals(declared.getSimpleName())) continue;
            impl = declared;
            break;
        }
        if (impl == null) {
            throw new RuntimeException("No matching type found in ptr mapper");
        }
        Constructor constructor = impl.getDeclaredConstructor(args);
        constructor.setAccessible(true);
        return constructor;
    }
}

