/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.impl.CxxObjectPtrImpl;

abstract class AbstractPtr {
    private Pointer peer;
    protected final Object bufferOwner;

    protected AbstractPtr(Pointer peer) {
        if (peer == null) {
            throw new IllegalArgumentException();
        }
        this.peer = peer;
        this.bufferOwner = null;
    }

    protected AbstractPtr(long peer, boolean owned, Object bufferOwner) {
        this.peer = CRuntime.createStrongPointer(peer, owned);
        this.bufferOwner = bufferOwner;
    }

    public Pointer getPeer() {
        return this.peer;
    }

    protected final long getRoot() {
        if (this.peer == null) {
            throw new UnsupportedOperationException("accessing a pointer which was freed");
        }
        return this.peer.getPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releasePointer(boolean force) {
        if (this.peer == null) {
            throw new UnsupportedOperationException("pointer was already freed");
        }
        AbstractPtr abstractPtr = this;
        synchronized (abstractPtr) {
            if (this.peer == null) {
                throw new UnsupportedOperationException("pointer was already freed");
            }
            if (!force) {
                if (this.peer.hasReleaser()) {
                    throw new UnsupportedOperationException("pointer has a releaser, should not be freed explicitly");
                }
                if (this.bufferOwner != null) {
                    throw new UnsupportedOperationException("pointer has an owner, should not be freed explicitly");
                }
            }
            if (this instanceof CxxObjectPtrImpl) {
                ((CxxObjectPtrImpl)this).invokeDeletePointer();
                this.peer = null;
            } else {
                long ptr = this.getRoot();
                this.peer = null;
                CRuntime.free(ptr);
            }
        }
    }
}

