/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

class BytePtrImpl
extends VoidPtrImpl
implements BytePtr {
    protected static final int ELEM_SIZE = 1;

    protected BytePtrImpl(Pointer peer) {
        super(peer);
    }

    protected BytePtrImpl(long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
    }

    BytePtrImpl(int capacity, boolean owned) {
        super(CRuntime.allocByte(capacity), owned, null);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public final Byte get() {
        return this.getValue(0);
    }

    @Override
    public final Byte get(int idx) {
        return this.getValue(idx);
    }

    @Override
    public final byte getValue() {
        return this.getValue(0);
    }

    @Override
    public byte getValue(int idx) {
        return CRuntime.loadByte(this.getRoot(), idx);
    }

    public final Byte[] toArray(int length) {
        return this.toArray(0, length);
    }

    public Byte[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Byte[] array = new Byte[length];
        this.copyTo(fromIndex, array, 0, length);
        return array;
    }

    @Override
    public final byte[] toByteArray(int length) {
        return this.toByteArray(0, length);
    }

    @Override
    public byte[] toByteArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return CRuntime.createByteArray(this.getRoot() + (long)(fromIndex * 1), toIndex - fromIndex);
    }

    public final void copyTo(Byte[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    public final void copyTo(Byte[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    public void copyTo(int srcOffset, Byte[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int idx = 0;
        while (idx < length) {
            dest[destOffset] = CRuntime.loadByte(root, srcOffset);
            ++idx;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public final void copyTo(byte[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(byte[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, byte[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyFromNativeByteArray(dest, destOffset, this.getRoot(), srcOffset, length);
    }

    @Override
    public void set(Byte obj) {
        this.setValue(obj);
    }

    @Override
    public void set(int idx, Byte obj) {
        this.setValue(idx, obj);
    }

    @Override
    public void setValue(byte value) {
        this.setValue(0, value);
    }

    @Override
    public void setValue(int idx, byte value) {
        CRuntime.storeByte(this.getRoot(), idx, value);
    }

    public void copyFrom(Byte[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    public void copyFrom(Byte[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    public void copyFrom(Byte[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    public void copyFrom(Byte[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int i = 0;
        while (i < length) {
            CRuntime.storeByte(root, destOffset, src[srcOffset]);
            ++i;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public void copyFrom(byte[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(byte[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(byte[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(byte[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyByteArray(this.getRoot(), destOffset, src, srcOffset, length);
    }

    @Override
    public BytePtr ofs(int elemOffset) {
        return new BytePtrImpl(this.getRoot() + (long)(elemOffset * 1), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public final BytePtr getGuarded(int length) {
        return this.getGuarded(0, length);
    }

    @Override
    public BytePtr getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedBytePtrImpl(this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toUTF8String() {
        int length = 0;
        while (this.getValue(length) != 0) {
            ++length;
        }
        return new String(this.toByteArray(length), Charset.forName("UTF-8"));
    }

    @Override
    public String toASCIIString() {
        int length = 0;
        while (this.getValue(length) != 0) {
            ++length;
        }
        return new String(this.toByteArray(length), Charset.forName("ASCII"));
    }

    @Override
    public String toString(int length) {
        return new String(this.toByteArray(length), Charset.forName("UTF-8"));
    }

    @Override
    public String toString(int length, String charset) throws UnsupportedEncodingException {
        return new String(this.toByteArray(length), charset);
    }

    private static class GuardedConstBytePtrImpl
    extends GuardedBytePtrImpl {
        public GuardedConstBytePtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Byte obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Byte obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Byte[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Byte[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Byte[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Byte[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(byte[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(byte[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(byte[] src, int srcOffset, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(byte[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final BytePtr ofs(int elemOffset) {
            return new GuardedConstBytePtrImpl(this.getRoot() + (long)(elemOffset * 1), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public BytePtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstBytePtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedBytePtrImpl
    extends BytePtrImpl
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedBytePtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public byte getValue(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return super.get(idx);
        }

        @Override
        public Byte[] toArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toArray(fromIndex, toIndex);
        }

        @Override
        public byte[] toByteArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toByteArray(fromIndex, toIndex);
        }

        @Override
        public void copyTo(int srcOffset, Byte[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void copyTo(int srcOffset, byte[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void setValue(int idx, byte value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(Byte[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public void copyFrom(byte[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public BytePtr ofs(int elemOffset) {
            return new GuardedBytePtrImpl(this.getRoot() + (long)(elemOffset * 1), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public BytePtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedBytePtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstBytePtrImpl
    extends BytePtrImpl {
        protected ConstBytePtrImpl(Pointer peer) {
            super(peer);
        }

        protected ConstBytePtrImpl(long peer, Object bufferOwner) {
            super(peer, bufferOwner);
        }

        ConstBytePtrImpl(int capacity, boolean owned) {
            super(capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Byte obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Byte obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Byte[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Byte[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Byte[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Byte[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(byte[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(byte[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(byte[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(byte[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final BytePtr ofs(int elemOffset) {
            return new ConstBytePtrImpl(this.getRoot() + (long)(elemOffset * 1), this);
        }

        @Override
        public BytePtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstBytePtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

