/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.DummyConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.UsageMarker;

public class MemberClassUsageMarker
extends UsageMarker {
    public static ClassVisitor wrapClassVisitor(ClassVisitor classVisitor) {
        if (classVisitor.getClass().equals(UsageMarker.class)) {
            return new MemberClassUsageMarker();
        }
        return classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.shouldBeMarkedAsUsed(programClass)) {
            boolean isOuterClassUsed = false;
            OuterClassFinder outerClassFinder = new OuterClassFinder();
            programClass.accept(new AllAttributeVisitor(new AllInnerClassesInfoVisitor(outerClassFinder)));
            if (outerClassFinder.outerClass != null) {
                isOuterClassUsed = this.isUsed(outerClassFinder.outerClass);
            }
            if (isOuterClassUsed) {
                this.markAsUsed(programClass);
                this.markProgramClassBody(programClass);
            } else if (this.shouldBeMarkedAsPossiblyUsed(programClass)) {
                this.markAsPossiblyUsed(programClass);
            }
        }
    }

    private static class OuterClassFinder
    implements InnerClassesInfoVisitor {
        public ProgramClass outerClass = null;
        private ProgramClass innerClass = null;

        private OuterClassFinder() {
        }

        @Override
        public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
            innerClassesInfo.innerClassConstantAccept(clazz, new DummyConstantVisitor(){

                @Override
                public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
                    innerClass = (ProgramClass)classConstant.referencedClass;
                }
            });
            if (clazz.equals(this.innerClass)) {
                innerClassesInfo.outerClassConstantAccept(clazz, new DummyConstantVisitor(){

                    @Override
                    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
                        outerClass = (ProgramClass)classConstant.referencedClass;
                    }
                });
            }
        }
    }
}

