/*
 * Decompiled with CFR 0.152.
 */
package org.moe.mdt.junit;

import apple.NSObject;
import apple.coregraphics.struct.CGRect;
import apple.foundation.NSArray;
import apple.foundation.NSBundle;
import apple.foundation.NSCharacterSet;
import apple.foundation.NSCoder;
import apple.foundation.NSData;
import apple.foundation.NSDictionary;
import apple.foundation.NSError;
import apple.foundation.NSString;
import apple.foundation.NSURL;
import apple.foundation.NSUserActivity;
import apple.uikit.UIAlertView;
import apple.uikit.UIApplication;
import apple.uikit.UILocalNotification;
import apple.uikit.UIScreen;
import apple.uikit.UIUserNotificationSettings;
import apple.uikit.UIViewController;
import apple.uikit.UIWindow;
import apple.uikit.c.UIKit;
import apple.uikit.protocol.UIApplicationDelegate;
import java.util.ArrayList;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.ByValue;
import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.Mapped;
import org.moe.natj.general.ann.NInt;
import org.moe.natj.general.ann.NUInt;
import org.moe.natj.general.ann.Owned;
import org.moe.natj.objc.ann.IsOptional;
import org.moe.natj.objc.ann.NotImplemented;
import org.moe.natj.objc.ann.ObjCBlock;
import org.moe.natj.objc.ann.Selector;
import org.moe.natj.objc.map.ObjCObjectMapper;

public class MoeRemoteTestRunner
extends NSObject
implements UIApplicationDelegate {
    private static String[] args;
    private UIWindow window;
    private final Runnable testRunner = new Runnable(){

        @Override
        public void run() {
            ArrayList classList = new ArrayList();
            for (String arg : args) {
                String[] subs;
                for (String sub : subs = arg.split("[,]")) {
                    if (sub.length() == 0) continue;
                    Class<?> cls = null;
                    try {
                        cls = Class.forName(sub);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    if (cls == null) continue;
                    classList.add(cls);
                }
            }
            if (classList.size() == 0) {
                String str = NSBundle.mainBundle().pathForResourceOfType("classlist", "txt");
                NSString contents = NSString.stringWithContentsOfFileEncodingError((String)str, (long)4L, null);
                NSArray components = contents.componentsSeparatedByCharactersInSet(NSCharacterSet.newlineCharacterSet());
                for (String sub : components) {
                    if (sub.length() == 0) continue;
                    Class<?> cls = null;
                    try {
                        cls = Class.forName(sub);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    if (cls == null) continue;
                    classList.add(cls);
                }
            }
            if (classList.size() > 0) {
                Class[] classArray = new Class[classList.size()];
                MoeRemoteTestRunner.runTests(classList.toArray(classArray));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
    };

    private static void runTests(Class<?>[] testsClasses) {
        final boolean runGCAfterTest = "true".equals(System.getProperty("moe.test.postgc", "false"));
        JUnitCore junit = new JUnitCore();
        junit.addListener(new RunListener(){

            @Override
            public void testRunStarted(Description description) throws Exception {
                for (Description child : description.getChildren()) {
                    this.defineTest(child);
                }
                MoeRemoteTestRunner.sendMessage("%TESTC  :" + description.testCount());
            }

            private void defineTest(Description description) {
                if (description.isTest()) {
                    MoeRemoteTestRunner.sendMessage("%TESTD  :" + description.getClassName() + "-" + description.getMethodName());
                    return;
                }
                if (description.getChildren() == null || description.getChildren().size() == 0) {
                    return;
                }
                for (Description child : description.getChildren()) {
                    this.defineTest(child);
                }
            }

            @Override
            public void testRunFinished(Result result) throws Exception {
                MoeRemoteTestRunner.sendMessage("%RUNTIME:" + result.getRunTime());
            }

            @Override
            public void testStarted(Description description) throws Exception {
                MoeRemoteTestRunner.sendMessage("%TESTS  :" + description.getClassName() + "-" + description.getMethodName());
            }

            @Override
            public void testFinished(Description description) throws Exception {
                MoeRemoteTestRunner.sendMessage("%TESTE  :" + description.getClassName() + "-" + description.getMethodName());
                if (runGCAfterTest) {
                    Runtime.getRuntime().gc();
                }
            }

            @Override
            public void testFailure(Failure failure) throws Exception {
                MoeRemoteTestRunner.sendMessage("%FAILED :" + failure.getTestHeader() + ":" + failure.getTrace());
            }

            @Override
            public void testIgnored(Description description) throws Exception {
                MoeRemoteTestRunner.sendMessage("%IGNORED:" + description.getClassName() + "-" + description.getMethodName());
            }
        });
        junit.run(testsClasses);
    }

    private static void sendMessage(String message) {
        System.out.print("\n" + message + "\n");
        System.out.flush();
    }

    public static void main(String[] args) {
        MoeRemoteTestRunner.args = args;
        UIKit.UIApplicationMain((int)0, null, null, (String)MoeRemoteTestRunner.class.getName());
    }

    @Owned
    @Selector(value="alloc")
    @Generated(value="NatJ")
    public static native MoeRemoteTestRunner alloc();

    @Generated(value="NatJ")
    protected MoeRemoteTestRunner(Pointer peer) {
        super(peer);
    }

    @Selector(value="application:didFinishLaunchingWithOptions:")
    public boolean applicationDidFinishLaunchingWithOptions(UIApplication application, NSDictionary launchOptions) {
        this.window = UIWindow.alloc().initWithFrame(UIScreen.mainScreen().bounds());
        UIViewController controller = UIViewController.alloc().init();
        this.window.setRootViewController(controller);
        this.window.makeKeyAndVisible();
        UIAlertView alert = UIAlertView.alloc().init();
        alert.setMessage("Running JUnit tests!");
        alert.show();
        new Thread(this.testRunner).start();
        return true;
    }

    @Selector(value="setWindow:")
    public void setWindow(UIWindow value) {
        this.window = value;
    }

    @Selector(value="window")
    public UIWindow window() {
        return this.window;
    }

    @NotImplemented
    @Selector(value="application:didChangeStatusBarFrame:")
    @IsOptional
    public native void applicationDidChangeStatusBarFrame(UIApplication var1, @ByValue CGRect var2);

    @NotImplemented
    @Selector(value="application:didChangeStatusBarOrientation:")
    @IsOptional
    public native void applicationDidChangeStatusBarOrientation(UIApplication var1, @NInt long var2);

    @NotImplemented
    @Selector(value="application:didDecodeRestorableStateWithCoder:")
    @IsOptional
    public native void applicationDidDecodeRestorableStateWithCoder(UIApplication var1, NSCoder var2);

    @NotImplemented
    @Selector(value="application:didFailToRegisterForRemoteNotificationsWithError:")
    @IsOptional
    public native void applicationDidFailToRegisterForRemoteNotificationsWithError(UIApplication var1, NSError var2);

    @NotImplemented
    @Selector(value="application:didReceiveLocalNotification:")
    @IsOptional
    public native void applicationDidReceiveLocalNotification(UIApplication var1, UILocalNotification var2);

    @NotImplemented
    @Selector(value="application:didReceiveRemoteNotification:")
    @IsOptional
    public native void applicationDidReceiveRemoteNotification(UIApplication var1, NSDictionary var2);

    @NotImplemented
    @Selector(value="application:didReceiveRemoteNotification:fetchCompletionHandler:")
    @IsOptional
    public native void applicationDidReceiveRemoteNotificationFetchCompletionHandler(UIApplication var1, NSDictionary var2, @ObjCBlock(name="call_applicationDidReceiveRemoteNotificationFetchCompletionHandler") UIApplicationDelegate.Block_applicationDidReceiveRemoteNotificationFetchCompletionHandler var3);

    @NotImplemented
    @Selector(value="application:didRegisterForRemoteNotificationsWithDeviceToken:")
    @IsOptional
    public native void applicationDidRegisterForRemoteNotificationsWithDeviceToken(UIApplication var1, NSData var2);

    @NotImplemented
    @Selector(value="application:handleEventsForBackgroundURLSession:completionHandler:")
    @IsOptional
    public native void applicationHandleEventsForBackgroundURLSessionCompletionHandler(UIApplication var1, String var2, @ObjCBlock(name="call_applicationHandleEventsForBackgroundURLSessionCompletionHandler") UIApplicationDelegate.Block_applicationHandleEventsForBackgroundURLSessionCompletionHandler var3);

    @NotImplemented
    @Selector(value="application:handleOpenURL:")
    @IsOptional
    public native boolean applicationHandleOpenURL(UIApplication var1, NSURL var2);

    @NotImplemented
    @Selector(value="application:openURL:sourceApplication:annotation:")
    @IsOptional
    public native boolean applicationOpenURLSourceApplicationAnnotation(UIApplication var1, NSURL var2, String var3, @Mapped(value=ObjCObjectMapper.class) Object var4);

    @NotImplemented
    @Selector(value="application:performFetchWithCompletionHandler:")
    @IsOptional
    public native void applicationPerformFetchWithCompletionHandler(UIApplication var1, @ObjCBlock(name="call_applicationPerformFetchWithCompletionHandler") UIApplicationDelegate.Block_applicationPerformFetchWithCompletionHandler var2);

    @NotImplemented
    @Selector(value="application:shouldRestoreApplicationState:")
    @IsOptional
    public native boolean applicationShouldRestoreApplicationState(UIApplication var1, NSCoder var2);

    @NotImplemented
    @Selector(value="application:shouldSaveApplicationState:")
    @IsOptional
    public native boolean applicationShouldSaveApplicationState(UIApplication var1, NSCoder var2);

    @NotImplemented
    @NUInt
    @Selector(value="application:supportedInterfaceOrientationsForWindow:")
    @IsOptional
    public native long applicationSupportedInterfaceOrientationsForWindow(UIApplication var1, UIWindow var2);

    @NotImplemented
    @Selector(value="application:viewControllerWithRestorationIdentifierPath:coder:")
    @IsOptional
    public native UIViewController applicationViewControllerWithRestorationIdentifierPathCoder(UIApplication var1, NSArray var2, NSCoder var3);

    @NotImplemented
    @Selector(value="application:willChangeStatusBarFrame:")
    @IsOptional
    public native void applicationWillChangeStatusBarFrame(UIApplication var1, @ByValue CGRect var2);

    @NotImplemented
    @Selector(value="application:willChangeStatusBarOrientation:duration:")
    @IsOptional
    public native void applicationWillChangeStatusBarOrientationDuration(UIApplication var1, @NInt long var2, double var4);

    @NotImplemented
    @Selector(value="application:willEncodeRestorableStateWithCoder:")
    @IsOptional
    public native void applicationWillEncodeRestorableStateWithCoder(UIApplication var1, NSCoder var2);

    @NotImplemented
    @Selector(value="application:willFinishLaunchingWithOptions:")
    @IsOptional
    public native boolean applicationWillFinishLaunchingWithOptions(UIApplication var1, NSDictionary var2);

    @NotImplemented
    @Selector(value="applicationDidBecomeActive:")
    @IsOptional
    public native void applicationDidBecomeActive(UIApplication var1);

    @NotImplemented
    @Selector(value="applicationDidEnterBackground:")
    @IsOptional
    public native void applicationDidEnterBackground(UIApplication var1);

    @NotImplemented
    @Selector(value="applicationDidFinishLaunching:")
    @IsOptional
    public native void applicationDidFinishLaunching(UIApplication var1);

    @NotImplemented
    @Selector(value="applicationDidReceiveMemoryWarning:")
    @IsOptional
    public native void applicationDidReceiveMemoryWarning(UIApplication var1);

    @NotImplemented
    @Selector(value="applicationProtectedDataDidBecomeAvailable:")
    @IsOptional
    public native void applicationProtectedDataDidBecomeAvailable(UIApplication var1);

    @NotImplemented
    @Selector(value="applicationProtectedDataWillBecomeUnavailable:")
    @IsOptional
    public native void applicationProtectedDataWillBecomeUnavailable(UIApplication var1);

    @NotImplemented
    @Selector(value="applicationSignificantTimeChange:")
    @IsOptional
    public native void applicationSignificantTimeChange(UIApplication var1);

    @NotImplemented
    @Selector(value="applicationWillEnterForeground:")
    @IsOptional
    public native void applicationWillEnterForeground(UIApplication var1);

    @NotImplemented
    @Selector(value="applicationWillResignActive:")
    @IsOptional
    public native void applicationWillResignActive(UIApplication var1);

    @NotImplemented
    @Selector(value="applicationWillTerminate:")
    @IsOptional
    public native void applicationWillTerminate(UIApplication var1);

    @NotImplemented
    @Selector(value="application:continueUserActivity:restorationHandler:")
    @IsOptional
    public native boolean applicationContinueUserActivityRestorationHandler(UIApplication var1, NSUserActivity var2, @ObjCBlock(name="call_applicationContinueUserActivityRestorationHandler") UIApplicationDelegate.Block_applicationContinueUserActivityRestorationHandler var3);

    @NotImplemented
    @Selector(value="application:didFailToContinueUserActivityWithType:error:")
    @IsOptional
    public native void applicationDidFailToContinueUserActivityWithTypeError(UIApplication var1, String var2, NSError var3);

    @NotImplemented
    @Selector(value="application:didRegisterUserNotificationSettings:")
    @IsOptional
    public native void applicationDidRegisterUserNotificationSettings(UIApplication var1, UIUserNotificationSettings var2);

    @NotImplemented
    @Selector(value="application:didUpdateUserActivity:")
    @IsOptional
    public native void applicationDidUpdateUserActivity(UIApplication var1, NSUserActivity var2);

    @NotImplemented
    @Selector(value="application:handleActionWithIdentifier:forLocalNotification:completionHandler:")
    @IsOptional
    public native void applicationHandleActionWithIdentifierForLocalNotificationCompletionHandler(UIApplication var1, String var2, UILocalNotification var3, @ObjCBlock(name="call_applicationHandleActionWithIdentifierForLocalNotificationCompletionHandler") UIApplicationDelegate.Block_applicationHandleActionWithIdentifierForLocalNotificationCompletionHandler var4);

    @NotImplemented
    @Selector(value="application:handleActionWithIdentifier:forRemoteNotification:completionHandler:")
    @IsOptional
    public native void applicationHandleActionWithIdentifierForRemoteNotificationCompletionHandler(UIApplication var1, String var2, NSDictionary var3, @ObjCBlock(name="call_applicationHandleActionWithIdentifierForRemoteNotificationCompletionHandler") UIApplicationDelegate.Block_applicationHandleActionWithIdentifierForRemoteNotificationCompletionHandler var4);

    @NotImplemented
    @Selector(value="application:shouldAllowExtensionPointIdentifier:")
    @IsOptional
    public native boolean applicationShouldAllowExtensionPointIdentifier(UIApplication var1, String var2);

    @NotImplemented
    @Selector(value="application:willContinueUserActivityWithType:")
    @IsOptional
    public native boolean applicationWillContinueUserActivityWithType(UIApplication var1, String var2);

    @NotImplemented
    @Selector(value="application:handleWatchKitExtensionRequest:reply:")
    @IsOptional
    public native void applicationHandleWatchKitExtensionRequestReply(UIApplication var1, NSDictionary var2, UIApplicationDelegate.Block_applicationHandleWatchKitExtensionRequestReply var3);

    static {
        NatJ.register();
    }

    public class MessageIds {
        public static final String TEST_RUN_START = "%TESTC  ";
        public static final String TEST_DEFINE = "%TESTD  ";
        public static final String TEST_START = "%TESTS  ";
        public static final String TEST_END = "%TESTE  ";
        public static final String TEST_ERROR = "%ERROR  ";
        public static final String TEST_FAILED = "%FAILED ";
        public static final String TEST_IGNORED = "%IGNORED";
        public static final String TEST_RUN_END = "%RUNTIME";
    }
}

