/*
 * Decompiled with CFR 0.152.
 */
package org.moe.mdt.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class MoeRemoteTestRunnerNoUI {
    private static String[] args;

    private static void runTests(Class<?>[] testsClasses) {
        final boolean runGCAfterTest = "true".equals(System.getProperty("moe.test.postgc", "false"));
        JUnitCore junit = new JUnitCore();
        junit.addListener(new RunListener(){

            @Override
            public void testRunStarted(Description description) throws Exception {
                for (Description child : description.getChildren()) {
                    this.defineTest(child);
                }
                MoeRemoteTestRunnerNoUI.sendMessage("%TESTC  :" + description.testCount());
            }

            private void defineTest(Description description) {
                if (description.isTest()) {
                    MoeRemoteTestRunnerNoUI.sendMessage("%TESTD  :" + description.getClassName() + "-" + description.getMethodName());
                    return;
                }
                if (description.getChildren() == null || description.getChildren().size() == 0) {
                    return;
                }
                for (Description child : description.getChildren()) {
                    this.defineTest(child);
                }
            }

            @Override
            public void testRunFinished(Result result) throws Exception {
                MoeRemoteTestRunnerNoUI.sendMessage("%RUNTIME:" + result.getRunTime());
            }

            @Override
            public void testStarted(Description description) throws Exception {
                MoeRemoteTestRunnerNoUI.sendMessage("%TESTS  :" + description.getClassName() + "-" + description.getMethodName());
            }

            @Override
            public void testFinished(Description description) throws Exception {
                MoeRemoteTestRunnerNoUI.sendMessage("%TESTE  :" + description.getClassName() + "-" + description.getMethodName());
                if (runGCAfterTest) {
                    Runtime.getRuntime().gc();
                }
            }

            @Override
            public void testFailure(Failure failure) throws Exception {
                MoeRemoteTestRunnerNoUI.sendMessage("%FAILED :" + failure.getTestHeader() + ":" + failure.getTrace());
            }

            @Override
            public void testIgnored(Description description) throws Exception {
                MoeRemoteTestRunnerNoUI.sendMessage("%IGNORED:" + description.getClassName() + "-" + description.getMethodName());
            }
        });
        junit.run(testsClasses);
    }

    private static void sendMessage(String message) {
        System.out.print("\n" + message + "\n");
        System.out.flush();
    }

    public static void main(final String[] args) {
        MoeRemoteTestRunnerNoUI.args = args;
        Runnable testRunner = new Runnable(){

            @Override
            public void run() {
                ArrayList classList = new ArrayList();
                for (String arg : args) {
                    String[] subs;
                    for (String sub : subs = arg.split("[,]")) {
                        if (sub.length() == 0) continue;
                        Class<?> cls = null;
                        try {
                            cls = Class.forName(sub);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        if (cls == null) continue;
                        classList.add(cls);
                    }
                }
                if (classList.size() == 0) {
                    try {
                        String line;
                        ClassLoader classLoader = MoeRemoteTestRunnerNoUI.class.getClassLoader();
                        File classListFile = new File(classLoader.getResource("classlist.txt").getPath());
                        BufferedReader reader = new BufferedReader(new FileReader(classListFile));
                        while ((line = reader.readLine()) != null) {
                            if (line.length() == 0) continue;
                            Class<?> cls = null;
                            try {
                                cls = Class.forName(line);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                            if (cls == null) continue;
                            classList.add(cls);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (classList.size() > 0) {
                    Class[] classArray = new Class[classList.size()];
                    MoeRemoteTestRunnerNoUI.runTests(classList.toArray(classArray));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.exit(0);
            }
        };
        new Thread(testRunner).start();
    }

    public class MessageIds {
        public static final String TEST_RUN_START = "%TESTC  ";
        public static final String TEST_DEFINE = "%TESTD  ";
        public static final String TEST_START = "%TESTS  ";
        public static final String TEST_END = "%TESTE  ";
        public static final String TEST_ERROR = "%ERROR  ";
        public static final String TEST_FAILED = "%FAILED ";
        public static final String TEST_IGNORED = "%IGNORED";
        public static final String TEST_RUN_END = "%RUNTIME";
    }
}

