/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Mapper;
import org.moe.natj.general.NativeObject;
import org.moe.natj.general.NativeRuntime;
import org.moe.natj.general.ann.Library;
import org.moe.natj.general.ann.Runtime;
import org.moe.natj.general.map.ReferenceMapper;
import org.moe.natj.general.ptr.ConstVoidPtr;

public class NatJ {
    private static final String OS_DARWIN = "Darwin";
    private static final String OS_WINDOWS = "Windows";
    private static String currentOS;
    private static boolean isDalvik;
    private static String dynlibExt;
    private static Map<Class<? extends NativeRuntime>, NativeRuntime> runtimes;
    private static Set<Class<? extends NativeRuntime>> runtimesUnderConstruction;
    private static NativeRuntime invalidRuntime;
    private static boolean initialized;
    private static ReferenceMapper referenceMapper;
    private static final ConcurrentHashMap<Class<?>, Class<? extends NativeRuntime>> CLASS_RUNTIME_CACHE;
    private static Map<String, String> resolvedLibraries;
    private static HashMap<Long, Object> strongReferences;
    private static HashMap<Long, WeakReference<Object>> weakReferences;

    private static boolean isDarwin() {
        return currentOS == OS_DARWIN;
    }

    private static boolean isWindows() {
        return currentOS == OS_WINDOWS;
    }

    private static boolean isDalvik() {
        return isDalvik;
    }

    public static boolean is64Bit() {
        return CRuntime.POINTER_SIZE == 8;
    }

    public static Mapper getReferenceMapper() {
        if (referenceMapper == null) {
            referenceMapper = new ReferenceMapper();
        }
        return referenceMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (initialized) return;
        Class<NatJ> clazz = NatJ.class;
        synchronized (NatJ.class) {
            if (initialized) return;
            try {
                java.lang.Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        NatJ.handleShutdown();
                    }
                });
                Properties props = System.getProperties();
                String os_name = props.getProperty("os.name");
                if (os_name == null) {
                    throw new RuntimeException("There is no system property with OS name.");
                }
                String os_name_lowercase = os_name.toLowerCase();
                if (os_name_lowercase.contains("windows")) {
                    currentOS = OS_WINDOWS;
                    dynlibExt = "dll";
                } else if (os_name_lowercase.contains("darwin") || os_name_lowercase.contains("mac")) {
                    currentOS = OS_DARWIN;
                    dynlibExt = "dylib";
                } else {
                    dynlibExt = "so";
                }
                String java_vm_name = props.getProperty("java.vm.name");
                isDalvik = "Dalvik".equals(java_vm_name);
                if (NatJ.isDalvik()) {
                    if (NatJ.isDarwin()) {
                        System.load("NatJ");
                    } else {
                        System.loadLibrary("natj");
                    }
                } else {
                    NatJ.lookUpLibrary("natj", true);
                }
                initialized = true;
                NatJ.initialize();
            }
            catch (RuntimeException e) {
                System.out.println("[ERROR] Cannot initialize NatJ");
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerRuntime(Class<? extends NativeRuntime> runtimeClass) {
        NatJ.init();
        Map<Class<? extends NativeRuntime>, NativeRuntime> map = runtimes;
        synchronized (map) {
            if (!runtimesUnderConstruction.contains(runtimeClass)) {
                NatJ.getOrCreateInstanceOfRuntimeClass(runtimeClass);
            }
        }
    }

    public static void register() {
        NatJ.init();
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        if (stackTrace.length < 2) {
            throw new RuntimeException("No useful stack trace: cannot register class.");
        }
        String name = stackTrace[1].getClassName();
        try {
            NativeRuntime runtime;
            Library lann;
            Class<?> type = Class.forName(name);
            if (!NativeObject.class.isAssignableFrom(type) && name.endsWith("$") && stackTrace.length > 3) {
                type = Class.forName(stackTrace[3].getClassName());
            }
            if ((lann = type.getAnnotation(Library.class)) != null) {
                NatJ.lookUpLibrary(lann.value(), true);
            }
            if ((runtime = NatJ.getRuntime(type, true)) != null) {
                runtime.doRegistration(type);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to register class " + name, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeRuntime getOrCreateInstanceOfRuntimeClass(Class<? extends NativeRuntime> runtimeClass) {
        Map<Class<? extends NativeRuntime>, NativeRuntime> map = runtimes;
        synchronized (map) {
            NativeRuntime runtime = runtimes.get(runtimeClass);
            if (runtime == invalidRuntime) {
                throw new RuntimeException("Invalid runtime for type " + runtimeClass.getName() + " was found");
            }
            if (runtime == null) {
                try {
                    Constructor<? extends NativeRuntime> constructor = runtimeClass.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    runtimesUnderConstruction.add(runtimeClass);
                    try {
                        runtime = constructor.newInstance(new Object[0]);
                    }
                    finally {
                        runtimesUnderConstruction.remove(runtimeClass);
                    }
                    runtimes.put(runtimeClass, runtime);
                }
                catch (Throwable ex) {
                    runtime = invalidRuntime;
                    runtimes.put(runtimeClass, runtime);
                    throw new RuntimeException("Exception during instantiation of runtime with type " + runtimeClass.getName(), ex);
                }
            }
            return runtime;
        }
    }

    private static Class<? extends NativeRuntime> getRuntimeClass(Class<?> type) {
        if (type == null) {
            return null;
        }
        Class<? extends NativeRuntime> nativeRuntime = CLASS_RUNTIME_CACHE.get(type);
        if (nativeRuntime == null && (nativeRuntime = NatJ.getRuntimeClassNoCache(type)) != null) {
            CLASS_RUNTIME_CACHE.putIfAbsent(type, nativeRuntime);
        }
        return nativeRuntime;
    }

    private static Class<? extends NativeRuntime> getRuntimeClassNoCache(Class<?> type) {
        Class<? extends NativeRuntime> runtimeClass = null;
        boolean isAnnotation = type.isAnnotation();
        while (type != null) {
            Object inter;
            Annotation anno;
            int n;
            Runtime rann = type.getAnnotation(Runtime.class);
            if (rann != null) {
                runtimeClass = rann.value();
                break;
            }
            if (isAnnotation) break;
            Object[] objectArray = type.getAnnotations();
            int n2 = objectArray.length;
            for (n = 0; n < n2 && (runtimeClass = NatJ.getRuntimeClassNoCache((anno = objectArray[n]).annotationType())) == null; ++n) {
            }
            objectArray = type.getInterfaces();
            n2 = objectArray.length;
            for (n = 0; n < n2 && (runtimeClass = NatJ.getRuntimeClassNoCache(inter = objectArray[n])) == null; ++n) {
            }
            if (runtimeClass != null) break;
            type = type.getSuperclass();
        }
        return runtimeClass;
    }

    private static NativeRuntime getRuntime(Class<?> type, boolean def) {
        NativeRuntime runtime = null;
        Class<? extends NativeRuntime> runtimeClass = NatJ.getRuntimeClass(type);
        if (def && runtimeClass == null) {
            runtimeClass = CRuntime.class;
        }
        if (runtimeClass != null) {
            runtime = NatJ.getOrCreateInstanceOfRuntimeClass(runtimeClass);
        }
        return runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String lookUpLibrary(String name, boolean load) {
        Map<String, String> map = resolvedLibraries;
        synchronized (map) {
            String path = resolvedLibraries.get(name);
            if (path != null) {
                return path == "" ? null : path;
            }
            path = System.getenv(name.toUpperCase() + "_LIBRARY");
            if (path != null) {
                resolvedLibraries.put(name, path);
                if (load) {
                    System.load(path);
                }
                return path;
            }
            String[] values = System.getProperty("java.library.path");
            if (values != null) {
                File file;
                String[] paths;
                for (String value : paths = values.split(File.pathSeparator)) {
                    String path2;
                    file = new File(value, "lib" + name + "." + dynlibExt);
                    if (!file.isFile()) continue;
                    try {
                        path2 = file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        path2 = file.getAbsolutePath();
                    }
                    resolvedLibraries.put(name, path2);
                    if (load) {
                        System.load(path2);
                    }
                    return path2;
                }
                if (NatJ.isDarwin()) {
                    for (String value : paths) {
                        String path3;
                        file = new File(value, name + ".framework/" + name);
                        if (!file.isFile()) continue;
                        try {
                            path3 = file.getCanonicalPath();
                        }
                        catch (IOException e) {
                            path3 = file.getAbsolutePath();
                        }
                        resolvedLibraries.put(name, path3);
                        if (load) {
                            System.load(path3);
                        }
                        return path3;
                    }
                }
            }
            if (NatJ.isDarwin()) {
                for (String path4 : new String[]{"/System/Library/Frameworks/" + name + ".framework"}) {
                    boolean res;
                    File file = new File(path4);
                    if (!file.exists() || !file.isDirectory()) continue;
                    String exec_path = path4 + "/" + name;
                    resolvedLibraries.put(name, exec_path);
                    if (load && !(res = NatJ.loadFramework(exec_path))) {
                        throw new RuntimeException("Cannot load executable file from system framework " + path4);
                    }
                    return exec_path;
                }
            } else if (NatJ.isDalvik()) {
                File file;
                path = null;
                try {
                    ClassLoader loader = NatJ.class.getClassLoader();
                    path = (String)loader.getClass().getMethod("findLibrary", String.class).invoke((Object)loader, name);
                }
                catch (Exception loader) {
                    // empty catch block
                }
                if (path != null && (file = new File(path)).exists() && file.isFile()) {
                    resolvedLibraries.put(name, path);
                    if (load) {
                        System.load(path);
                    }
                    return path;
                }
            }
            if (!NatJ.isWindows()) {
                for (String prefix : new String[]{"/usr/lib/lib", "/usr/lib32/lib", "/usr/lib64/lib"}) {
                    String path5 = prefix + name + "." + dynlibExt;
                    File file = new File(path5);
                    if (!file.exists() || !file.isFile()) continue;
                    resolvedLibraries.put(name, path5);
                    if (load) {
                        System.load(path5);
                    }
                    return path5;
                }
            }
            resolvedLibraries.put(name, "");
        }
        return null;
    }

    private static long id(Object obj) {
        return (0xCAFEBABE00000000L | (long)System.identityHashCode(obj) & 0xFFFFFFFFL | 1L) & (CRuntime.POINTER_SIZE == 4 ? 0xFFFFFFFFL : -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long addStrongReference(Object reference) {
        if (reference == null) {
            return 0L;
        }
        long nextId = NatJ.id(reference);
        HashMap<Long, Object> hashMap = strongReferences;
        synchronized (hashMap) {
            while (strongReferences.containsKey(nextId)) {
                ++nextId;
            }
            strongReferences.put(nextId, reference);
        }
        return nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeStrongReference(long key) {
        if (key == 0L) {
            return false;
        }
        HashMap<Long, Object> hashMap = strongReferences;
        synchronized (hashMap) {
            return strongReferences.remove(key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getStrongReference(long key) {
        if (key == 0L) {
            return null;
        }
        HashMap<Long, Object> hashMap = strongReferences;
        synchronized (hashMap) {
            return strongReferences.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long addWeakReference(Object reference) {
        if (reference == null) {
            return 0L;
        }
        long nextId = NatJ.id(reference);
        WeakReference<Object> weakReference = new WeakReference<Object>(reference);
        HashMap<Long, WeakReference<Object>> hashMap = weakReferences;
        synchronized (hashMap) {
            while (weakReferences.containsKey(nextId)) {
                ++nextId;
            }
            weakReferences.put(nextId, weakReference);
        }
        return nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeWeakReference(long key) {
        if (key == 0L) {
            return false;
        }
        HashMap<Long, WeakReference<Object>> hashMap = weakReferences;
        synchronized (hashMap) {
            return weakReferences.remove(key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getWeakReference(long key) {
        WeakReference<Object> weakReference;
        if (key == 0L) {
            return null;
        }
        HashMap<Long, WeakReference<Object>> hashMap = weakReferences;
        synchronized (hashMap) {
            weakReference = weakReferences.get(key);
        }
        if (weakReference != null) {
            return weakReference.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeFunctionPtr(Object callback) {
        Map<Class<? extends NativeRuntime>, NativeRuntime> map = runtimes;
        synchronized (map) {
            for (Map.Entry<Class<? extends NativeRuntime>, NativeRuntime> runtimeEntry : runtimes.entrySet()) {
                runtimeEntry.getValue().tryToDisposeCallback(callback);
            }
        }
    }

    private static boolean isSuperClassOf(Class<?> superCls, Class<?> subCls) {
        try {
            subCls.asSubclass(superCls);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static Object getOrCreateObjectCacheForRuntime(Class<? extends NativeRuntime> runtimeClass, Object instance, CacheConstructor constructor) {
        try {
            Field cacheField = instance.getClass().getDeclaredField("__natjCache");
            cacheField.setAccessible(true);
            Object value = null;
            if (NatJ.isSuperClassOf(cacheField.getType(), HashMap.class)) {
                HashMap cache;
                Object fieldValue = cacheField.get(instance);
                if (fieldValue != null && fieldValue instanceof HashMap) {
                    cache = (HashMap)fieldValue;
                    value = cache.get(runtimeClass);
                } else {
                    cache = new HashMap();
                    cacheField.set(instance, cache);
                }
                if (value == null && constructor != null) {
                    value = constructor.constructCache();
                    cache.put(runtimeClass, value);
                }
            }
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getObjectCacheForRuntime(Class<? extends NativeRuntime> runtimeClass, Object instance) {
        try {
            Object fieldValue;
            Field cacheField = instance.getClass().getDeclaredField("__natjCache");
            cacheField.setAccessible(true);
            Object value = null;
            if (NatJ.isSuperClassOf(cacheField.getType(), HashMap.class) && (fieldValue = cacheField.get(instance)) != null && fieldValue instanceof HashMap) {
                HashMap cache = (HashMap)fieldValue;
                value = cache.get(runtimeClass);
            }
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getAndRemoveObjectCacheForRuntime(Class<? extends NativeRuntime> runtimeClass, Object instance) {
        try {
            Field cacheField = instance.getClass().getDeclaredField("__natjCache");
            cacheField.setAccessible(true);
            Object fieldValue = cacheField.get(instance);
            Object value = null;
            if (fieldValue != null && fieldValue instanceof HashMap) {
                HashMap cache = (HashMap)fieldValue;
                value = cache.remove(runtimeClass);
            }
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Method getMethod(Class<?> cls, String name, Class<?>[] argTypes, int[] idxRef, int[] countRef) {
        if (name == null) {
            return null;
        }
        Method[] methods = cls.getDeclaredMethods();
        int count = methods.length;
        for (int idx = 0; idx < count; ++idx) {
            Method meth = methods[idx];
            if (meth.isSynthetic() || !meth.getName().equals(name) || argTypes != null && (argTypes.length != 1 || argTypes[0] != Void.TYPE) && !Arrays.equals(meth.getParameterTypes(), argTypes)) continue;
            if (idxRef != null) {
                idxRef[0] = idx;
            }
            if (countRef != null) {
                countRef[0] = count;
            }
            return meth;
        }
        return null;
    }

    public static int getMethodIndex(Method method) {
        Method[] methods = method.getDeclaringClass().getDeclaredMethods();
        int n = methods.length;
        for (int i = 0; i < n; ++i) {
            if (!methods[i].equals(method)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isBoxedPrimitiveType(Class<?> type) {
        return type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class;
    }

    public static Annotation[][] getParameterAnnotationsInherited(Method method) {
        Object[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return new Annotation[0][];
        }
        ArrayList results = new ArrayList(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            results.add(new ArrayList());
        }
        ArrayList supers = new ArrayList();
        Class<?> methodDeclaredKlass = method.getDeclaringClass();
        Class<?>[] interfaces = methodDeclaredKlass.getInterfaces();
        supers.addAll(Arrays.asList(interfaces));
        Class<?> superClass = methodDeclaredKlass.getSuperclass();
        if (superClass != null) {
            supers.add(superClass);
        }
        block3: for (Class clazz : supers) {
            try {
                Method[] methodArray = clazz.getDeclaredMethods();
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    Method sm = methodArray[i];
                    int modifiers = sm.getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isFinal(modifiers) || !method.getName().equals(sm.getName()) || !Arrays.equals(parameterTypes, sm.getParameterTypes())) continue;
                    int idx = 0;
                    for (Annotation[] annotations : sm.getParameterAnnotations()) {
                        ((List)results.get(idx)).addAll(Arrays.asList(annotations));
                        ++idx;
                    }
                    continue block3;
                }
            }
            catch (Throwable throwable) {
            }
        }
        int idx = 0;
        for (Annotation[] annotations : method.getParameterAnnotations()) {
            ((List)results.get(idx)).addAll(Arrays.asList(annotations));
            ++idx;
        }
        Annotation[][] annotationArray = new Annotation[parameterTypes.length][];
        for (int i = 0; i < parameterTypes.length; ++i) {
            List al = (List)results.get(i);
            Annotation[] aa = new Annotation[al.size()];
            aa = al.toArray(aa);
            annotationArray[i] = aa;
        }
        return annotationArray;
    }

    public static JavaObjectConstructionInfo buildJavaObjectConstructionInfo(NativeRuntime defaultRuntime, Class<?> type, Class<?> mapperClass, Annotation callback, Object typeInfo, boolean owned, boolean byvalue, boolean arg) {
        JavaObjectConstructionInfo info = new JavaObjectConstructionInfo();
        info.owned = owned;
        info.arg = arg;
        info.type = type;
        info.callback = callback;
        info.data = null;
        info.byvalue = byvalue;
        if (ConstVoidPtr.class.isAssignableFrom(type)) {
            info.ref = true;
            info.mapper = NatJ.getReferenceMapper();
            info.data = new Object[]{typeInfo, null};
        } else {
            info.ref = false;
            if (mapperClass == null) {
                if (callback != null) {
                    NativeRuntime runtime = NatJ.getRuntime(callback.annotationType(), true);
                    info.mapper = runtime == null ? null : runtime.getCallbackMapper();
                } else if (String.class == type) {
                    info.mapper = defaultRuntime == null ? null : defaultRuntime.getStringMapper();
                } else {
                    NativeRuntime runtime = NatJ.getRuntime(type, false);
                    if (runtime == null) {
                        runtime = defaultRuntime;
                    }
                    info.mapper = runtime == null ? null : runtime.getObjectMapper();
                }
            } else {
                NativeRuntime runtime = NatJ.getRuntime(mapperClass, true);
                if (runtime != null) {
                    info.mapper = runtime.getMapper(mapperClass);
                }
            }
        }
        return info;
    }

    public static NativeObjectConstructionInfo buildNativeObjectConstructionInfo(NativeRuntime defaultRuntime, Class<?> type, Class<?> mapperClass, Annotation callback, boolean owned, boolean byvalue, boolean arg) {
        NativeObjectConstructionInfo info = new NativeObjectConstructionInfo();
        info.owned = owned;
        info.arg = arg;
        info.callback = callback;
        info.byvalue = byvalue;
        if (ConstVoidPtr.class.isAssignableFrom(type)) {
            info.ref = true;
            info.mapper = NatJ.getReferenceMapper();
        } else {
            info.ref = false;
            if (mapperClass == null) {
                if (callback != null) {
                    NativeRuntime runtime = NatJ.getRuntime(callback.annotationType(), true);
                    if (runtime != null) {
                        info.mapper = runtime.getCallbackMapper();
                    }
                } else if (String.class == type) {
                    info.mapper = defaultRuntime == null ? null : defaultRuntime.getStringMapper();
                } else {
                    NativeRuntime runtime = NatJ.getRuntime(type, false);
                    if (runtime == null) {
                        runtime = defaultRuntime;
                    }
                    info.mapper = runtime == null ? null : runtime.getObjectMapper();
                }
            } else {
                NativeRuntime runtime = NatJ.getRuntime(mapperClass, true);
                if (runtime != null) {
                    info.mapper = runtime.getMapper(mapperClass);
                }
            }
        }
        return info;
    }

    public static Object toJava(long peer, JavaObjectConstructionInfo info) {
        if (info.mapper == null) {
            return null;
        }
        return info.mapper.toJava(peer, info);
    }

    public static long toNative(Object instance, NativeObjectConstructionInfo info) {
        if (info.mapper == null) {
            return 0L;
        }
        return info.mapper.toNative(instance, info);
    }

    private static native void initialize();

    private static native void handleShutdown();

    public static native String getPlatformName();

    public static native boolean loadFramework(String var0);

    static {
        runtimes = new HashMap<Class<? extends NativeRuntime>, NativeRuntime>();
        runtimesUnderConstruction = new HashSet<Class<? extends NativeRuntime>>();
        invalidRuntime = new NativeRuntime(null, null, null){

            @Override
            public void tryToDisposeCallback(Object callback) {
            }

            @Override
            protected void doRegistration(Class<?> type) {
            }

            @Override
            public byte getDefaultUnboxPolicy() {
                return 0;
            }
        };
        initialized = false;
        referenceMapper = null;
        CLASS_RUNTIME_CACHE = new ConcurrentHashMap();
        resolvedLibraries = new HashMap<String, String>();
        strongReferences = new HashMap();
        weakReferences = new HashMap();
    }

    public static class NativeObjectConstructionInfo {
        public Object callback;
        public boolean owned;
        public boolean byvalue;
        public boolean arg;
        public boolean ref;
        public Object data;
        public Mapper mapper;
    }

    public static class JavaObjectConstructionInfo {
        public Class<?> type;
        public Object callback;
        public boolean owned;
        public boolean byvalue;
        public boolean arg;
        public boolean ref;
        public Object data;
        public Mapper mapper;
    }

    public static interface CacheConstructor {
        public Object constructCache();
    }
}

