/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import java.lang.reflect.Constructor;
import org.moe.natj.c.CRuntime;
import org.moe.natj.c.OpaquePtr;
import org.moe.natj.c.StructObject;
import org.moe.natj.cxx.CxxObject;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.NFloat;
import org.moe.natj.general.ann.NInt;
import org.moe.natj.general.ann.NLong;
import org.moe.natj.general.ann.NUInt;
import org.moe.natj.general.ann.NULong;
import org.moe.natj.general.ptr.ConstVoidPtr;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.impl.AbstractPtr;
import org.moe.natj.general.ptr.impl.AbstractTypedPtr;
import org.moe.natj.general.ptr.impl.BoolPtrImpl;
import org.moe.natj.general.ptr.impl.BytePtrImpl;
import org.moe.natj.general.ptr.impl.CharPtrImpl;
import org.moe.natj.general.ptr.impl.CxxObjectPtrImpl;
import org.moe.natj.general.ptr.impl.DoublePtrImpl;
import org.moe.natj.general.ptr.impl.FloatPtrImpl;
import org.moe.natj.general.ptr.impl.IntPtrImpl;
import org.moe.natj.general.ptr.impl.LongPtrImpl;
import org.moe.natj.general.ptr.impl.NFloatPtrImpl;
import org.moe.natj.general.ptr.impl.NIntPtrImpl;
import org.moe.natj.general.ptr.impl.NLongPtrImpl;
import org.moe.natj.general.ptr.impl.NUIntPtrImpl;
import org.moe.natj.general.ptr.impl.NULongPtrImpl;
import org.moe.natj.general.ptr.impl.ObjCObjectPtrImpl;
import org.moe.natj.general.ptr.impl.ShortPtrImpl;
import org.moe.natj.general.ptr.impl.StructPtrImpl;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;
import org.moe.natj.objc.ObjCObject;

class IndirectPtrImpl<E extends ConstVoidPtr, T>
extends AbstractTypedPtr<T, E> {
    protected static final int ELEM_SIZE = CRuntime.POINTER_SIZE;
    protected final int depth;

    protected IndirectPtrImpl(Class<T> type, int depth, Pointer peer) {
        super(type, peer);
        this.depth = depth;
    }

    private IndirectPtrImpl(Class<T> cls, int depth, long peer, Object bufferOwner) {
        super(cls, peer, bufferOwner);
        this.depth = depth;
    }

    IndirectPtrImpl(Class<T> cls, int depth, int capacity, boolean owned) {
        super(cls, CRuntime.allocPointer(capacity), owned);
        this.depth = depth;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    private final Pointer getPointer(int idx) {
        long peer = CRuntime.loadPointer(this.getRoot(), idx);
        if (peer == 0L) {
            return null;
        }
        return new Pointer(peer);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public E get(int idx) {
        if (this.depth <= 1) {
            throw new RuntimeException("Invalid reference depth!");
        }
        if (this.depth == 2) {
            Class cls = this.type;
            Pointer pointer = this.getPointer(idx);
            if (pointer == null) {
                return null;
            }
            if (cls == Void.class) {
                return (E)new VoidPtrImpl(pointer);
            }
            if (cls == Boolean.class) {
                return (E)new BoolPtrImpl(pointer);
            }
            if (cls == Byte.class) {
                return (E)new BytePtrImpl(pointer);
            }
            if (cls == Short.class) {
                return (E)new ShortPtrImpl(pointer);
            }
            if (cls == Character.class) {
                return (E)new CharPtrImpl(pointer);
            }
            if (cls == Integer.class) {
                return (E)new IntPtrImpl(pointer);
            }
            if (cls == Long.class) {
                return (E)new LongPtrImpl(pointer);
            }
            if (cls == Float.class) {
                return (E)new FloatPtrImpl(pointer);
            }
            if (cls == Double.class) {
                return (E)new DoublePtrImpl(pointer);
            }
            if (cls == NInt.class) {
                return (E)new NIntPtrImpl(pointer);
            }
            if (cls == NUInt.class) {
                return (E)new NUIntPtrImpl(pointer);
            }
            if (cls == NLong.class) {
                return (E)new NLongPtrImpl(pointer);
            }
            if (cls == NULong.class) {
                return (E)new NULongPtrImpl(pointer);
            }
            if (cls == NFloat.class) {
                return (E)new NFloatPtrImpl(pointer);
            }
            if (StructObject.class.isAssignableFrom(cls)) {
                return (E)new StructPtrImpl(cls, pointer);
            }
            if (ObjCObject.class.isAssignableFrom(cls)) {
                return (E)new ObjCObjectPtrImpl(cls, pointer);
            }
            if (CxxObject.class.isAssignableFrom(cls)) {
                return (E)new CxxObjectPtrImpl(cls, pointer);
            }
            if (OpaquePtr.class.isAssignableFrom(cls)) {
                try {
                    Class<?> impl = null;
                    for (Class<?> declared : cls.getDeclaredClasses()) {
                        if (!"Impl".equals(declared.getSimpleName())) continue;
                        impl = declared;
                        break;
                    }
                    if (impl == null) {
                        throw new RuntimeException("No suitable indirect ptr impl was found");
                    }
                    Constructor constructor = impl.getDeclaredConstructor(Pointer.class);
                    constructor.setAccessible(true);
                    return (E)((ConstVoidPtr)constructor.newInstance(pointer));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to construct pointer", e);
                }
            }
            throw new RuntimeException("Invalid reference core type!");
        }
        Pointer pointer = this.getPointer(idx);
        if (pointer == null) {
            return null;
        }
        return (E)new IndirectPtrImpl<E, T>(this.type, this.depth - 1, pointer);
    }

    @Override
    public void set(int idx, E obj) {
        if (obj == null) {
            CRuntime.storePointer(this.getRoot(), idx, 0L);
        } else {
            CRuntime.storePointer(this.getRoot(), idx, ((AbstractPtr)obj).getRoot());
        }
    }

    @Override
    public Ptr<E> ofs(int elemOffset) {
        return new IndirectPtrImpl<E, T>(this.type, this.depth, this.getRoot() + (long)(elemOffset * ELEM_SIZE), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public Ptr<E> getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedIndirectPtrImpl(this.type, this.depth, this.getRoot(), this, fromIndex, toIndex);
    }

    private static class GuardedConstIndirectPtrImpl<E extends ConstVoidPtr, T>
    extends GuardedIndirectPtrImpl<E, T> {
        public GuardedConstIndirectPtrImpl(Class<T> type, int depth, long peer, Object bufferOwner, int low, int hi) {
            super(type, depth, peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public final void set(E value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void set(int idx, E value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(E[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(E[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(E[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(E[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Ptr<E> ofs(int elemOffset) {
            return new GuardedConstIndirectPtrImpl<E, T>(this.type, this.depth, this.getRoot() + (long)(elemOffset * ELEM_SIZE), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public Ptr<E> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstIndirectPtrImpl<E, T>(this.type, this.depth, this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedIndirectPtrImpl<E extends ConstVoidPtr, T>
    extends IndirectPtrImpl<E, T>
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedIndirectPtrImpl(Class<T> type, int depth, long peer, Object bufferOwner, int low, int hi) {
            super(type, depth, peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public E get(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return (E)super.get(idx);
        }

        @Override
        public void copyTo(int srcOffset, E[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void set(int idx, E value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(E[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public Ptr<E> ofs(int elemOffset) {
            return new GuardedIndirectPtrImpl<E, T>(this.type, this.depth, this.getRoot() + (long)(elemOffset * ELEM_SIZE), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public Ptr<E> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedIndirectPtrImpl<E, T>(this.type, this.depth, this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstIndirectPtrImpl<E extends ConstVoidPtr, T>
    extends IndirectPtrImpl<E, T> {
        protected ConstIndirectPtrImpl(Class<T> type, int depth, Pointer peer) {
            super(type, depth, peer);
        }

        private ConstIndirectPtrImpl(Class<T> cls, int depth, long peer, Object bufferOwner) {
            super(cls, depth, peer, bufferOwner);
        }

        ConstIndirectPtrImpl(Class<T> cls, int depth, int capacity, boolean owned) {
            super(cls, depth, CRuntime.allocPointer(capacity), owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public final void set(E value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void set(int idx, E value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(E[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(E[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(E[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(E[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Ptr<E> ofs(int elemOffset) {
            return new ConstIndirectPtrImpl<E, T>(this.type, this.depth, this.getRoot() + (long)(elemOffset * ELEM_SIZE), this);
        }

        @Override
        public Ptr<E> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstIndirectPtrImpl(this.type, this.depth, this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

