/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.ShortPtr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

class ShortPtrImpl
extends VoidPtrImpl
implements ShortPtr {
    protected static final int ELEM_SIZE = 2;

    protected ShortPtrImpl(Pointer peer) {
        super(peer);
    }

    protected ShortPtrImpl(long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
    }

    ShortPtrImpl(int capacity, boolean owned) {
        super(CRuntime.allocShort(capacity), owned, null);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public final Short get() {
        return this.getValue(0);
    }

    @Override
    public final Short get(int idx) {
        return this.getValue(idx);
    }

    @Override
    public final short getValue() {
        return this.getValue(0);
    }

    @Override
    public short getValue(int idx) {
        return CRuntime.loadShort(this.getRoot(), idx);
    }

    public final Short[] toArray(int length) {
        return this.toArray(0, length);
    }

    public Short[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Short[] array = new Short[length];
        this.copyTo(fromIndex, array, 0, length);
        return array;
    }

    @Override
    public final short[] toShortArray(int length) {
        return this.toShortArray(0, length);
    }

    @Override
    public short[] toShortArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return CRuntime.createShortArray(this.getRoot() + (long)(fromIndex * 2), toIndex - fromIndex);
    }

    public final void copyTo(Short[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    public final void copyTo(Short[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    public void copyTo(int srcOffset, Short[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int idx = 0;
        while (idx < length) {
            dest[destOffset] = CRuntime.loadShort(root, srcOffset);
            ++idx;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public final void copyTo(short[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(short[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, short[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyFromNativeShortArray(dest, destOffset, this.getRoot(), srcOffset, length);
    }

    @Override
    public void set(Short obj) {
        this.setValue(obj);
    }

    @Override
    public void set(int idx, Short obj) {
        this.setValue(idx, obj);
    }

    @Override
    public void setValue(short value) {
        this.setValue(0, value);
    }

    @Override
    public void setValue(int idx, short value) {
        CRuntime.storeShort(this.getRoot(), idx, value);
    }

    public void copyFrom(Short[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    public void copyFrom(Short[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    public void copyFrom(Short[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    public void copyFrom(Short[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int i = 0;
        while (i < length) {
            CRuntime.storeShort(root, destOffset, src[srcOffset]);
            ++i;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public void copyFrom(short[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(short[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(short[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(short[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyShortArray(this.getRoot(), destOffset, src, srcOffset, length);
    }

    @Override
    public ShortPtr ofs(int elemOffset) {
        return new ShortPtrImpl(this.getRoot() + (long)(elemOffset * 2), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public final ShortPtr getGuarded(int length) {
        return this.getGuarded(0, length);
    }

    @Override
    public ShortPtr getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedShortPtrImpl(this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    private static class GuardedConstShortPtrImpl
    extends GuardedShortPtrImpl {
        public GuardedConstShortPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Short obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Short obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Short[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Short[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Short[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Short[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(short[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(short[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(short[] src, int srcOffset, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(short[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ShortPtr ofs(int elemOffset) {
            return new GuardedConstShortPtrImpl(this.getRoot() + (long)(elemOffset * 2), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public ShortPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstShortPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedShortPtrImpl
    extends ShortPtrImpl
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedShortPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public short getValue(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return super.get(idx);
        }

        @Override
        public Short[] toArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toArray(fromIndex, toIndex);
        }

        @Override
        public short[] toShortArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toShortArray(fromIndex, toIndex);
        }

        @Override
        public void copyTo(int srcOffset, Short[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void copyTo(int srcOffset, short[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void setValue(int idx, short value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(Short[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public void copyFrom(short[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public ShortPtr ofs(int elemOffset) {
            return new GuardedShortPtrImpl(this.getRoot() + (long)(elemOffset * 2), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public ShortPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedShortPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstShortPtrImpl
    extends ShortPtrImpl {
        protected ConstShortPtrImpl(Pointer peer) {
            super(peer);
        }

        protected ConstShortPtrImpl(long peer, Object bufferOwner) {
            super(peer, bufferOwner);
        }

        ConstShortPtrImpl(int capacity, boolean owned) {
            super(capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Short obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Short obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Short[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Short[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Short[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Short[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(short[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(short[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(short[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(short[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ShortPtr ofs(int elemOffset) {
            return new ConstShortPtrImpl(this.getRoot() + (long)(elemOffset * 2), this);
        }

        @Override
        public ShortPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstShortPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

