/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.objc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.moe.natj.general.NativeObject;
import org.moe.natj.objc.ann.ObjCProtocolName;
import org.moe.natj.objc.ann.Selector;

public class ObjCSelectorsFinder {
    Map<Method, Selector> methodsWithSelectorsForClass = new HashMap<Method, Selector>();

    public Selector getSelectorForMethod(Method m) {
        Selector sel = this.methodsWithSelectorsForClass.get(m);
        return sel;
    }

    public void prepareParentsSelectorsList(Class<?> inputClass) {
        this.methodsWithSelectorsForClass = ObjCSelectorsFinder.getMethodsWithSelectorsForClass(inputClass);
    }

    private static Map<Method, Selector> getMethodsWithSelectorsForClass(Class<?> type) {
        HashMap<Method, Selector> selectors = new HashMap<Method, Selector>();
        LinkedList classList = new LinkedList();
        Class<?>[] implInterfaces = type.getInterfaces();
        classList.addAll(Arrays.asList(implInterfaces));
        classList.addAll(ObjCSelectorsFinder.getParents(type));
        Method classMethod = null;
        for (Class clazz : classList) {
            Method[] lookupMethods = null;
            if (!clazz.isInterface()) {
                lookupMethods = clazz.getDeclaredMethods();
            } else {
                if (!clazz.isInterface() || clazz.getAnnotation(ObjCProtocolName.class) == null) continue;
                lookupMethods = clazz.getMethods();
            }
            for (Method meth : lookupMethods) {
                Selector selAnn = meth.getAnnotation(Selector.class);
                if (selAnn == null) continue;
                try {
                    classMethod = type.getMethod(meth.getName(), meth.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    System.out.printf("Did not found method:" + meth.getName() + " For class:" + type.getSimpleName(), new Object[0]);
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    throw new RuntimeException("SecurityException in Registrator getMethodsWithSelectorsForClass");
                }
                if (!classMethod.getDeclaringClass().equals(type) || classMethod.getAnnotation(Selector.class) != null || Modifier.isNative(classMethod.getModifiers())) continue;
                selectors.put(classMethod, selAnn);
            }
        }
        return selectors;
    }

    private static List<Class<?>> getParents(Class<?> type) {
        LinkedList resultList = new LinkedList();
        Class<?> superCls = type.getSuperclass();
        if (superCls != null && NativeObject.class.isAssignableFrom(superCls)) {
            resultList.add(superCls);
            Class<?>[] interfaces = superCls.getInterfaces();
            if (interfaces.length > 0) {
                resultList.addAll(Arrays.asList(interfaces));
            }
            resultList.addAll(ObjCSelectorsFinder.getParents(superCls));
        }
        return resultList;
    }
}

