/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import net.orfjackal.retrolambda.Config$$Lambda$1;
import net.orfjackal.retrolambda.Config$$Lambda$2;
import net.orfjackal.retrolambda.Config$$Lambda$3;
import net.orfjackal.retrolambda.Config$$Lambda$4;
import net.orfjackal.retrolambda.Config$$Lambda$5;
import net.orfjackal.retrolambda.Config$$Lambda$6;

public class Config {
    private static final String PREFIX = "retrolambda.";
    public static final String BYTECODE_VERSION = "retrolambda.bytecodeVersion";
    public static final String DEFAULT_METHODS = "retrolambda.defaultMethods";
    public static final String NATJ_SUPPORT = "retrolambda.natjSupport";
    public static final String INPUT_DIR = "retrolambda.inputDir";
    public static final String OUTPUT_DIR = "retrolambda.outputDir";
    public static final String CLASSPATH = "retrolambda.classpath";
    public static final String INCLUDED_FILES = "retrolambda.includedFiles";
    private static final List<String> requiredProperties = new ArrayList<String>();
    private static final List<String> requiredPropertiesHelp = new ArrayList<String>();
    private static final List<String> optionalPropertiesHelp = new ArrayList<String>();
    private static final Map<Integer, String> bytecodeVersionNames = new HashMap<Integer, String>();
    private final Properties p;

    public Config(Properties p) {
        this.p = p;
    }

    public boolean isFullyConfigured() {
        return this.hasAllRequiredProperties();
    }

    private boolean hasAllRequiredProperties() {
        for (String requiredParameter : requiredProperties) {
            if (this.p.getProperty(requiredParameter) != null) continue;
            return false;
        }
        return true;
    }

    public int getBytecodeVersion() {
        return Integer.parseInt(this.p.getProperty(BYTECODE_VERSION, "51"));
    }

    public String getJavaVersion() {
        return bytecodeVersionNames.getOrDefault(this.getBytecodeVersion(), "unknown version");
    }

    public boolean isDefaultMethodsEnabled() {
        return Boolean.parseBoolean(this.p.getProperty(DEFAULT_METHODS, "false"));
    }

    public boolean isNatJSupportEnabled() {
        return Boolean.parseBoolean(this.p.getProperty(NATJ_SUPPORT, "false"));
    }

    public Path getInputDir() {
        return Paths.get(this.getRequiredProperty(INPUT_DIR), new String[0]);
    }

    public Path getOutputDir() {
        String outputDir = this.p.getProperty(OUTPUT_DIR);
        if (outputDir == null) {
            return this.getInputDir();
        }
        return Paths.get(outputDir, new String[0]);
    }

    public String getClasspath() {
        return this.getRequiredProperty(CLASSPATH);
    }

    private String getRequiredProperty(String key) {
        String value = this.p.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("Missing required property: " + key);
        }
        return value;
    }

    public List<Path> getIncludedFiles() {
        String files = this.p.getProperty(INCLUDED_FILES);
        if (files == null) {
            return null;
        }
        return Arrays.asList(files.split(File.pathSeparator)).stream().filter(Config$$Lambda$1.lambdaFactory$()).map(Config$$Lambda$2.lambdaFactory$()).collect(Collectors.toList());
    }

    public String getHelp() {
        String options = (String)requiredProperties.stream().map(Config$$Lambda$3.lambdaFactory$()).reduce(Config$$Lambda$4.lambdaFactory$()).get();
        return "Usage: java " + options + " [-javaagent:retrolambda.jar] -jar retrolambda.jar\n\nRetrolambda is a backporting tool for classes which use lambda expressions\nand have been compiled with Java 8, to run on Java 7 (maybe even Java 5).\nSee https://github.com/orfjackal/retrolambda\n\nCopyright (c) 2013-2015  Esko Luontola <www.orfjackal.net>\nThis software is released under the Apache License 2.0.\nThe license text is at http://www.apache.org/licenses/LICENSE-2.0\n\nRequired system properties:\n\n" + (String)requiredPropertiesHelp.stream().reduce(Config$$Lambda$5.lambdaFactory$()).get() + "\nOptional system properties:\n\n" + (String)optionalPropertiesHelp.stream().reduce(Config$$Lambda$6.lambdaFactory$()).get() + "\nIf the Java agent is used, then Retrolambda will use it to capture the\nlambda classes generated by Java. Otherwise Retrolambda will hook into\nJava's internal lambda dumping API, which is more susceptible to suddenly\nstopping to work between Java releases.\n";
    }

    private static void requiredParameterHelp(String key, String ... lines) {
        requiredProperties.add(key);
        requiredPropertiesHelp.add(Config.formatPropertyHelp(key, lines));
    }

    private static void optionalParameterHelp(String key, String ... lines) {
        optionalPropertiesHelp.add(Config.formatPropertyHelp(key, lines));
    }

    private static String formatPropertyHelp(String key, String ... lines) {
        String s = "  " + key + "\n";
        for (String line : lines) {
            s = s + "      " + line + "\n";
        }
        return s;
    }

    private static /* synthetic */ String lambda$getHelp$5(String a, String b) {
        return a + "\n" + b;
    }

    private static /* synthetic */ String lambda$getHelp$4(String a, String b) {
        return a + "\n" + b;
    }

    private static /* synthetic */ String lambda$getHelp$3(String a, String b) {
        return a + " " + b;
    }

    private static /* synthetic */ String lambda$getHelp$2(String key) {
        return "-D" + key + "=?";
    }

    private static /* synthetic */ Path lambda$getIncludedFiles$1(String x$0) {
        return Paths.get(x$0, new String[0]);
    }

    private static /* synthetic */ boolean lambda$getIncludedFiles$0(String s) {
        return !s.isEmpty();
    }

    static {
        bytecodeVersionNames.put(196653, "Java 1.1");
        bytecodeVersionNames.put(46, "Java 1.2");
        bytecodeVersionNames.put(47, "Java 1.3");
        bytecodeVersionNames.put(48, "Java 1.4");
        bytecodeVersionNames.put(49, "Java 5");
        bytecodeVersionNames.put(50, "Java 6");
        bytecodeVersionNames.put(51, "Java 7");
        bytecodeVersionNames.put(52, "Java 8");
        Config.optionalParameterHelp(BYTECODE_VERSION, "Major version number for the generated bytecode. For a list, see", "offset 7 at http://en.wikipedia.org/wiki/Java_class_file#General_layout", "Default value is 51 (i.e. Java 7)");
        Config.optionalParameterHelp(DEFAULT_METHODS, "Whether to backport default methods and static methods on interfaces.", "LIMITATIONS: All backported interfaces and all classes which implement", "them or call their static methods must be backported together,", "with one execution of Retrolambda.", "Disabled by default. Enable by setting to \"true\"");
        Config.requiredParameterHelp(INPUT_DIR, "Input directory from where the original class files are read.");
        Config.optionalParameterHelp(OUTPUT_DIR, "Output directory into where the generated class files are written.", "Defaults to same as retrolambda.inputDir");
        Config.requiredParameterHelp(CLASSPATH, "Classpath containing the original class files and their dependencies.");
        Config.optionalParameterHelp(INCLUDED_FILES, "List of files to process, instead of processing all files.", "This is useful for a build tool to support incremental compilation.");
    }

    static /* synthetic */ boolean access$lambda$0(String string) {
        return Config.lambda$getIncludedFiles$0(string);
    }

    static /* synthetic */ Path access$lambda$1(String string) {
        return Config.lambda$getIncludedFiles$1(string);
    }

    static /* synthetic */ String access$lambda$2(String string) {
        return Config.lambda$getHelp$2(string);
    }

    static /* synthetic */ String access$lambda$3(String string, String string2) {
        return Config.lambda$getHelp$3(string, string2);
    }

    static /* synthetic */ String access$lambda$4(String string, String string2) {
        return Config.lambda$getHelp$4(string, string2);
    }

    static /* synthetic */ String access$lambda$5(String string, String string2) {
        return Config.lambda$getHelp$5(string, string2);
    }
}

