/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.orfjackal.retrolambda.Config;
import net.orfjackal.retrolambda.Retrolambda;

public class Main {
    public static void main(String[] args) {
        Config config;
        System.out.println("Retrolambda " + Main.getVersion());
        if (!Main.isRunningJava8()) {
            System.out.println("Error! Not running under Java 8");
            System.exit(1);
        }
        if (!(config = new Config(System.getProperties())).isFullyConfigured()) {
            System.out.print(config.getHelp());
            return;
        }
        try {
            Retrolambda.run(config);
        }
        catch (Throwable t) {
            System.out.println("Error! Failed to transform some classes");
            t.printStackTrace(System.out);
            System.exit(1);
        }
    }

    public static boolean isRunningJava8() {
        try {
            Class.forName("java.util.stream.Stream");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String getVersion() {
        Properties p = new Properties();
        try {
            InputStream in = Main.class.getResourceAsStream("/META-INF/maven/net.orfjackal.retrolambda/retrolambda/pom.properties");
            Throwable throwable = null;
            try {
                if (in != null) {
                    p.load(in);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return p.getProperty("version", "DEVELOPMENT-VERSION");
    }
}

