/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.orfjackal.retrolambda.Config;
import net.orfjackal.retrolambda.NonDelegatingClassLoader;
import net.orfjackal.retrolambda.PreMain;
import net.orfjackal.retrolambda.Retrolambda$$Lambda$1;
import net.orfjackal.retrolambda.Retrolambda$$Lambda$4;
import net.orfjackal.retrolambda.Retrolambda$$Lambda$5;
import net.orfjackal.retrolambda.Transformers;
import net.orfjackal.retrolambda.files.BytecodeFileVisitor;
import net.orfjackal.retrolambda.files.ClassSaver;
import net.orfjackal.retrolambda.files.FilteringFileVisitor;
import net.orfjackal.retrolambda.interfaces.ClassHierarchyAnalyzer;
import net.orfjackal.retrolambda.interfaces.ClassInfo;
import net.orfjackal.retrolambda.lambdas.LambdaClassDumper;
import net.orfjackal.retrolambda.lambdas.LambdaClassSaver;

public class Retrolambda {
    public static void run(Config config) throws Throwable {
        int bytecodeVersion = config.getBytecodeVersion();
        boolean defaultMethodsEnabled = config.isDefaultMethodsEnabled();
        boolean natjSupportEnabled = config.isNatJSupportEnabled();
        Path inputDir = config.getInputDir();
        Path outputDir = config.getOutputDir();
        String classpath = config.getClasspath();
        List<Path> includedFiles = config.getIncludedFiles();
        System.out.println("Bytecode version: " + bytecodeVersion + " (" + config.getJavaVersion() + ")");
        System.out.println("Default methods:  " + defaultMethodsEnabled);
        System.out.println("NatJ support:     " + natjSupportEnabled);
        System.out.println("Input directory:  " + inputDir);
        System.out.println("Output directory: " + outputDir);
        System.out.println("Classpath:        " + classpath);
        if (includedFiles != null) {
            System.out.println("Included files:   " + includedFiles.size());
        }
        if (!Files.isDirectory(inputDir, new LinkOption[0])) {
            System.out.println("Nothing to do; not a directory: " + inputDir);
            return;
        }
        Thread.currentThread().setContextClassLoader(new NonDelegatingClassLoader(Retrolambda.asUrls(classpath)));
        final ClassHierarchyAnalyzer analyzer = new ClassHierarchyAnalyzer();
        ClassSaver saver = new ClassSaver(outputDir);
        Transformers transformers = new Transformers(bytecodeVersion, defaultMethodsEnabled, natjSupportEnabled, analyzer);
        LambdaClassSaver lambdaClassSaver = new LambdaClassSaver(saver, transformers);
        LambdaClassDumper dumper = new LambdaClassDumper(lambdaClassSaver);
        Throwable throwable = null;
        try {
            if (PreMain.isAgentLoaded()) {
                PreMain.setLambdaClassSaver(lambdaClassSaver);
            } else {
                dumper.install();
            }
            Retrolambda.visitFiles(inputDir, includedFiles, new BytecodeFileVisitor(){

                @Override
                protected void visit(byte[] bytecode) {
                    analyzer.analyze(bytecode);
                }
            });
            List<ClassInfo> interfaces = analyzer.getInterfaces();
            List<ClassInfo> classes = analyzer.getClasses();
            ArrayList<byte[]> transformed = new ArrayList<byte[]>();
            for (ClassInfo c : interfaces) {
                transformed.add(transformers.extractInterfaceCompanion(c.reader));
                transformed.add(transformers.backportInterface(c.reader));
            }
            for (ClassInfo c : classes) {
                transformed.add(transformers.backportClass(c.reader));
            }
            for (byte[] bytecode : transformed) {
                saver.save(bytecode);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (dumper != null) {
                if (throwable != null) {
                    try {
                        dumper.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    dumper.close();
                }
            }
        }
    }

    static void visitFiles(Path inputDir, List<Path> includedFiles, FileVisitor<Path> visitor) throws IOException {
        if (includedFiles != null) {
            visitor = new FilteringFileVisitor(includedFiles, visitor);
        }
        Files.walkFileTree(inputDir, visitor);
    }

    private static URL[] asUrls(String classpath) {
        String[] paths = classpath.split(System.getProperty("path.separator"));
        return (URL[])Arrays.asList(paths).stream().map(Retrolambda$$Lambda$1.lambdaFactory$()).map(Retrolambda$$Lambda$4.lambdaFactory$()).toArray(Retrolambda$$Lambda$5.lambdaFactory$());
    }

    private static URL uriToUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ URL[] lambda$asUrls$1(int x$0) {
        return new URL[x$0];
    }

    private static /* synthetic */ URI lambda$asUrls$0(String s) {
        return Paths.get(s, new String[0]).toUri();
    }

    static /* synthetic */ URI access$lambda$0(String string) {
        return Retrolambda.lambda$asUrls$0(string);
    }

    static /* synthetic */ URL access$lambda$1(URI uRI) {
        return Retrolambda.uriToUrl(uRI);
    }

    static /* synthetic */ URL[] access$lambda$2(int n) {
        return Retrolambda.lambda$asUrls$1(n);
    }
}

