/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda;

import java.util.Optional;
import net.orfjackal.retrolambda.LowerBytecodeVersion;
import net.orfjackal.retrolambda.asm.ClassReader;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.ClassWriter;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.interfaces.AddMethodDefaultImplementations;
import net.orfjackal.retrolambda.interfaces.ClassHierarchyAnalyzer;
import net.orfjackal.retrolambda.interfaces.ExtractInterfaceCompanionClass;
import net.orfjackal.retrolambda.interfaces.FixInvokeStaticOnInterfaceMethod;
import net.orfjackal.retrolambda.interfaces.RemoveBridgeMethods;
import net.orfjackal.retrolambda.interfaces.RemoveDefaultMethodBodies;
import net.orfjackal.retrolambda.interfaces.RemoveStaticMethods;
import net.orfjackal.retrolambda.interfaces.UpdateRelocatedMethodInvocations;
import net.orfjackal.retrolambda.interfaces.WarnAboutDefaultAndStaticMethods;
import net.orfjackal.retrolambda.lambdas.BackportLambdaClass;
import net.orfjackal.retrolambda.lambdas.BackportLambdaInvocations;
import net.orfjackal.retrolambda.trywithresources.SwallowSuppressedExceptions;
import org.moe.retrolambda.natj.AddMissingAnnotations;
import org.moe.retrolambda.natj.AddMissingNatJRegister;

public class Transformers {
    private final int targetVersion;
    private final boolean defaultMethodsEnabled;
    private boolean natjSupportEnabled;
    private final ClassHierarchyAnalyzer analyzer;

    public Transformers(int targetVersion, boolean defaultMethodsEnabled, boolean natjSupportEnabled, ClassHierarchyAnalyzer analyzer) {
        this.targetVersion = targetVersion;
        this.defaultMethodsEnabled = defaultMethodsEnabled;
        this.natjSupportEnabled = natjSupportEnabled;
        this.analyzer = analyzer;
    }

    public byte[] backportLambdaClass(ClassReader reader) {
        return this.transform(reader, next -> {
            if (this.defaultMethodsEnabled) {
                this.analyzer.analyze(reader);
                next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
                next = new AddMethodDefaultImplementations(next, this.analyzer);
            } else {
                next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
            }
            next = new BackportLambdaClass(next);
            return next;
        });
    }

    public byte[] backportClass(ClassReader reader) {
        return this.transform(reader, next -> {
            if (this.defaultMethodsEnabled) {
                next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
                if (this.natjSupportEnabled) {
                    next = new AddMissingAnnotations(next);
                }
                next = new AddMethodDefaultImplementations(next, this.analyzer);
            }
            next = new BackportLambdaInvocations(next);
            if (this.natjSupportEnabled) {
                next = new AddMissingNatJRegister(next);
            }
            return next;
        });
    }

    public byte[] backportInterface(ClassReader reader) {
        return this.transform(reader, next -> {
            if (this.defaultMethodsEnabled) {
                next = new RemoveStaticMethods(next);
                next = new RemoveDefaultMethodBodies(next);
                next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
            } else {
                next = new RemoveStaticMethods(next);
                next = new WarnAboutDefaultAndStaticMethods(next);
            }
            next = new RemoveBridgeMethods(next);
            next = new BackportLambdaInvocations(next);
            return next;
        });
    }

    public byte[] extractInterfaceCompanion(ClassReader reader) {
        Optional<Type> companion = this.analyzer.getCompanionClass(Type.getObjectType(reader.getClassName()));
        if (!companion.isPresent()) {
            return null;
        }
        return this.transform(reader, next -> {
            next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
            next = new ExtractInterfaceCompanionClass(next, (Type)companion.get());
            next = new BackportLambdaInvocations(next);
            return next;
        });
    }

    private byte[] transform(ClassReader reader, ClassVisitorChain chain) {
        ClassWriter writer;
        ClassVisitor next = writer = new ClassWriter(1);
        next = new LowerBytecodeVersion(next, this.targetVersion);
        if (this.targetVersion < 51) {
            next = new SwallowSuppressedExceptions(next);
        }
        next = new FixInvokeStaticOnInterfaceMethod(next);
        next = chain.wrap(next);
        reader.accept(next, 0);
        return writer.toByteArray();
    }

    private static interface ClassVisitorChain {
        public ClassVisitor wrap(ClassVisitor var1);
    }
}

