/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.files;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.orfjackal.retrolambda.asm.ClassReader;

public class ClassSaver {
    private final Path outputDir;

    public ClassSaver(Path outputDir) {
        this.outputDir = outputDir;
    }

    public void save(byte[] bytecode) throws IOException {
        if (bytecode == null) {
            return;
        }
        ClassReader cr = new ClassReader(bytecode);
        Path outputFile = this.outputDir.resolve(cr.getClassName() + ".class");
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        Files.write(outputFile, bytecode, new OpenOption[0]);
    }
}

