/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.interfaces;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.orfjackal.retrolambda.asm.ClassReader;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.interfaces.ClassInfo;
import net.orfjackal.retrolambda.interfaces.MethodInfo;
import net.orfjackal.retrolambda.interfaces.MethodKind;
import net.orfjackal.retrolambda.interfaces.MethodRef;
import net.orfjackal.retrolambda.interfaces.MethodSignature;
import net.orfjackal.retrolambda.util.Bytecode;
import net.orfjackal.retrolambda.util.Flags;

public class ClassHierarchyAnalyzer {
    private final Map<Type, ClassInfo> classes = new HashMap<Type, ClassInfo>();
    private final Map<MethodRef, MethodRef> relocatedMethods = new HashMap<MethodRef, MethodRef>();

    public void analyze(byte[] bytecode) {
        this.analyze(new ClassReader(bytecode));
    }

    public void analyze(ClassReader cr) {
        ClassInfo c = new ClassInfo(cr);
        this.classes.put(c.type, c);
        if (Flags.hasFlag(cr.getAccess(), 512)) {
            this.analyzeInterface(c, cr);
        } else {
            this.analyzeClass(c, cr);
        }
    }

    private void analyzeClass(final ClassInfo c, ClassReader cr) {
        cr.accept(new ClassVisitor(327680){
            private String owner;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.owner = name;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (ClassHierarchyAnalyzer.isConstructor(name) || ClassHierarchyAnalyzer.isStaticMethod(access)) {
                    return null;
                }
                c.addMethod(new MethodRef(this.owner, name, desc), new MethodKind.Implemented());
                return null;
            }
        }, 1);
    }

    private void analyzeInterface(final ClassInfo c, ClassReader cr) {
        cr.accept(new ClassVisitor(327680){
            private String owner;
            private String companion;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.owner = name;
                this.companion = name + "$";
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodRef method = new MethodRef(this.owner, name, desc);
                if (ClassHierarchyAnalyzer.isAbstractMethod(access)) {
                    c.addMethod(method, new MethodKind.Abstract());
                } else if (ClassHierarchyAnalyzer.isDefaultMethod(access)) {
                    MethodRef defaultImpl = new MethodRef(this.companion, name, Bytecode.prependArgumentType(desc, Type.getObjectType(this.owner)));
                    c.enableCompanionClass();
                    c.addMethod(method, new MethodKind.Default(defaultImpl));
                } else if (ClassHierarchyAnalyzer.isStaticMethod(access)) {
                    ClassHierarchyAnalyzer.this.relocatedMethods.put(method, new MethodRef(this.companion, name, desc));
                    c.enableCompanionClass();
                }
                return null;
            }
        }, 1);
    }

    private static boolean isConstructor(String name) {
        return name.equals("<init>");
    }

    private static boolean isAbstractMethod(int access) {
        return Flags.hasFlag(access, 1024);
    }

    private static boolean isStaticMethod(int access) {
        return Flags.hasFlag(access, 8);
    }

    private static boolean isDefaultMethod(int access) {
        return !ClassHierarchyAnalyzer.isAbstractMethod(access) && !ClassHierarchyAnalyzer.isStaticMethod(access);
    }

    public List<ClassInfo> getInterfaces() {
        return this.classes.values().stream().filter(ClassInfo::isInterface).collect(Collectors.toList());
    }

    public List<ClassInfo> getClasses() {
        return this.classes.values().stream().filter(ClassInfo::isClass).collect(Collectors.toList());
    }

    private ClassInfo getClass(Type type) {
        return this.classes.getOrDefault(type, new ClassInfo());
    }

    public MethodRef getMethodCallTarget(MethodRef original) {
        return this.relocatedMethods.getOrDefault(original, original);
    }

    public MethodRef getMethodDefaultImplementation(MethodRef interfaceMethod) {
        MethodSignature signature = interfaceMethod.getSignature();
        for (MethodInfo method : this.getDefaultMethods(Type.getObjectType(interfaceMethod.owner))) {
            if (!method.signature.equals(signature)) continue;
            return method.getDefaultMethodImpl();
        }
        return null;
    }

    public Optional<Type> getCompanionClass(Type type) {
        return this.getClass(type).getCompanionClass();
    }

    public List<MethodInfo> getDefaultMethods(Type type) {
        return this.getMethods(type).stream().filter(m -> m.kind instanceof MethodKind.Default).collect(Collectors.toList());
    }

    public Collection<MethodInfo> getMethods(Type type) {
        ClassInfo c = this.getClass(type);
        HashMap<MethodSignature, MethodInfo> methods = new HashMap<MethodSignature, MethodInfo>();
        for (Type iface : c.getInterfaces()) {
            for (MethodInfo m : this.getMethods(iface)) {
                if (this.isAlreadyInherited(m, methods)) continue;
                methods.put(m.signature, m);
            }
        }
        if (c.superclass != null) {
            for (MethodInfo m : this.getMethods(c.superclass)) {
                if (this.isAlreadyInherited(m, methods)) continue;
                methods.put(m.signature, m);
            }
        }
        for (MethodInfo m : c.getMethods()) {
            methods.put(m.signature, m);
        }
        return methods.values();
    }

    private boolean isAlreadyInherited(MethodInfo subject, Map<MethodSignature, MethodInfo> existingMethods) {
        MethodInfo existing = existingMethods.get(subject.signature);
        return existing != null && this.getAllInterfaces(existing.owner).contains(subject.owner);
    }

    private Set<Type> getAllInterfaces(Type interfaceType) {
        assert (this.getClass(interfaceType).isInterface()) : "not interface: " + interfaceType;
        HashSet<Type> results = new HashSet<Type>();
        results.add(interfaceType);
        for (Type parentInterface : this.getClass(interfaceType).getInterfaces()) {
            results.addAll(this.getAllInterfaces(parentInterface));
        }
        return results;
    }
}

