/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.interfaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.orfjackal.retrolambda.asm.ClassReader;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.interfaces.MethodInfo;
import net.orfjackal.retrolambda.interfaces.MethodKind;
import net.orfjackal.retrolambda.interfaces.MethodRef;
import net.orfjackal.retrolambda.util.Flags;

public class ClassInfo {
    public final ClassReader reader;
    private final int access;
    public final Type type;
    public final Type superclass;
    private final List<Type> interfaces = new ArrayList<Type>();
    private final List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private Optional<Type> companionClass = Optional.empty();

    public ClassInfo() {
        this.reader = null;
        this.access = 0;
        this.type = null;
        this.superclass = null;
    }

    public ClassInfo(ClassReader cr) {
        this.reader = cr;
        this.access = cr.getAccess();
        this.type = Type.getObjectType(cr.getClassName());
        this.superclass = cr.getSuperName() == null ? null : Type.getObjectType(cr.getSuperName());
        for (String iface : cr.getInterfaces()) {
            this.interfaces.add(Type.getObjectType(iface));
        }
    }

    public List<Type> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public List<MethodInfo> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public void addMethod(MethodRef method, MethodKind kind) {
        this.methods.add(new MethodInfo(method.getSignature(), Type.getObjectType(method.owner), kind));
    }

    public Optional<Type> getCompanionClass() {
        return this.companionClass;
    }

    public void enableCompanionClass() {
        this.companionClass = Optional.of(Type.getObjectType(this.type.getInternalName() + "$"));
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public boolean isInterface() {
        return Flags.hasFlag(this.access, 512);
    }
}

