/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.interfaces;

import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.FieldVisitor;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.util.Bytecode;
import net.orfjackal.retrolambda.util.Flags;

public class ExtractInterfaceCompanionClass
extends ClassVisitor {
    private final Type companion;
    private String interfaceName;

    public ExtractInterfaceCompanionClass(ClassVisitor next, Type companion) {
        super(327680, next);
        this.companion = companion;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.interfaceName = name;
        name = this.companion.getInternalName();
        access &= 0xFFFFFDFF;
        super.visit(version, access &= 0xFFFFFBFF, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (Flags.hasFlag(access, 1024)) {
            return null;
        }
        if (Flags.isClassInitializer(name, desc, access)) {
            return null;
        }
        if (Flags.hasFlag(access, 2)) {
            access &= 0xFFFFFFFD;
        }
        if (!Flags.hasFlag(access, 8)) {
            access |= 8;
            desc = Bytecode.prependArgumentType(desc, Type.getObjectType(this.interfaceName));
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }
}

