/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.interfaces;

import java.util.Objects;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.google.common.base.MoreObjects;
import net.orfjackal.retrolambda.interfaces.MethodKind;
import net.orfjackal.retrolambda.interfaces.MethodRef;
import net.orfjackal.retrolambda.interfaces.MethodSignature;

public class MethodInfo {
    public final MethodSignature signature;
    public final Type owner;
    public final MethodKind kind;

    public MethodInfo(String name, String desc, Class<?> owner, MethodKind kind) {
        this(new MethodSignature(name, desc), Type.getType(owner), kind);
    }

    public MethodInfo(MethodSignature signature, Type owner, MethodKind kind) {
        this.signature = signature;
        this.owner = owner;
        this.kind = kind;
    }

    public MethodRef getDefaultMethodImpl() {
        return ((MethodKind.Default)this.kind).defaultImpl;
    }

    public MethodRef toMethodRef() {
        return new MethodRef(this.owner.getInternalName(), this.signature.name, this.signature.desc);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo that = (MethodInfo)obj;
        return this.signature.equals(that.signature) && this.owner.equals(that.owner) && this.kind.equals(that.kind);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.owner, this.kind);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.signature).addValue(this.owner).addValue(this.kind).toString();
    }
}

