/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.interfaces;

import java.util.Objects;
import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.google.common.base.MoreObjects;
import net.orfjackal.retrolambda.interfaces.MethodSignature;

public final class MethodRef {
    public final String owner;
    public final String name;
    public final String desc;

    public MethodRef(Class<?> owner, String name, String desc) {
        this(Type.getInternalName(owner), name, desc);
    }

    public MethodRef(String owner, String name, String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public MethodSignature getSignature() {
        return new MethodSignature(this.name, this.desc);
    }

    public Handle toHandle(int tag) {
        return new Handle(tag, this.owner, this.name, this.desc);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodRef)) {
            return false;
        }
        MethodRef that = (MethodRef)obj;
        return this.owner.equals(that.owner) && this.name.equals(that.name) && this.desc.equals(that.desc);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.name, this.desc);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.owner).addValue(this.name).addValue(this.desc).toString();
    }
}

