/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.interfaces;

import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.tree.MethodNode;
import net.orfjackal.retrolambda.util.Flags;

public class RemoveDefaultMethodBodies
extends ClassVisitor {
    public RemoveDefaultMethodBodies(ClassVisitor next) {
        super(327680, next);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (RemoveDefaultMethodBodies.isPrivateInstanceMethod(access)) {
            return null;
        }
        if (RemoveDefaultMethodBodies.isDefaultMethod(access)) {
            MethodVisitor next = super.visitMethod(access | 0x400, name, desc, signature, exceptions);
            return new RemoveMethodBody(next, access, name, desc, signature, exceptions);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private static boolean isPrivateInstanceMethod(int access) {
        return Flags.hasFlag(access, 2) && !Flags.hasFlag(access, 8);
    }

    private static boolean isDefaultMethod(int access) {
        return !Flags.hasFlag(access, 1024) && !Flags.hasFlag(access, 8);
    }

    private static class RemoveMethodBody
    extends MethodNode {
        private final MethodVisitor next;

        private RemoveMethodBody(MethodVisitor next, int access, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.next = next;
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            this.instructions.clear();
            super.accept(this.next);
        }
    }
}

