/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.interfaces;

import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.util.Flags;

public class WarnAboutDefaultAndStaticMethods
extends ClassVisitor {
    private String interfaceName;

    public WarnAboutDefaultAndStaticMethods(ClassVisitor next) {
        super(327680, next);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!Flags.hasFlag(access, 512)) {
            throw new IllegalArgumentException(name + " is not an interface");
        }
        this.interfaceName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (Flags.hasFlag(access, 8)) {
            if (!Flags.isClassInitializer(name, desc, access) && !name.startsWith("lambda$")) {
                this.printWarning("a static method", name);
            }
        } else if (!Flags.hasFlag(access, 1024)) {
            this.printWarning("a default method", name);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private void printWarning(String methodKind, String methodName) {
        System.out.println("WARNING: The interface " + this.interfaceName + " has " + methodKind + " \"" + methodName + "\" but backporting default methods is not enabled");
    }
}

