/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.FieldVisitor;
import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.lambdas.Handles;
import net.orfjackal.retrolambda.lambdas.LambdaFactoryMethod;
import net.orfjackal.retrolambda.lambdas.LambdaNaming;
import net.orfjackal.retrolambda.lambdas.LambdaReifier;

public class BackportLambdaClass
extends ClassVisitor {
    private static final String SINGLETON_FIELD_NAME = "instance";
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private String lambdaClass;
    private Type constructor;
    private Handle implMethod;
    private Handle accessMethod;
    private LambdaFactoryMethod factoryMethod;

    public BackportLambdaClass(ClassVisitor next) {
        super(327680, next);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.lambdaClass = name;
        LambdaReifier.setLambdaClass(this.lambdaClass);
        this.implMethod = LambdaReifier.getLambdaImplMethod();
        this.accessMethod = LambdaReifier.getLambdaAccessMethod();
        this.factoryMethod = LambdaReifier.getLambdaFactoryMethod();
        if (superName.equals("java/lang/invoke/MagicLambdaImpl")) {
            superName = JAVA_LANG_OBJECT;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("<init>")) {
            this.constructor = Type.getMethodType(desc);
        }
        if (LambdaNaming.isSerializationHook(access, name, desc)) {
            return null;
        }
        MethodVisitor next = super.visitMethod(access, name, desc, signature, exceptions);
        next = new RemoveMagicLambdaConstructorCall(next);
        next = new CallPrivateImplMethodsViaAccessMethods(next);
        return next;
    }

    @Override
    public void visitEnd() {
        if (this.isStateless()) {
            this.makeSingleton();
        }
        this.generateFactoryMethod();
        super.visitEnd();
    }

    private void makeSingleton() {
        FieldVisitor fv = super.visitField(26, SINGLETON_FIELD_NAME, this.singletonFieldDesc(), null, null);
        fv.visitEnd();
        MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, this.lambdaClass);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, this.lambdaClass, "<init>", "()V", false);
        mv.visitFieldInsn(179, this.lambdaClass, SINGLETON_FIELD_NAME, this.singletonFieldDesc());
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void generateFactoryMethod() {
        MethodVisitor mv = this.cv.visitMethod(9, this.factoryMethod.getName(), this.factoryMethod.getDesc(), null, null);
        mv.visitCode();
        if (this.isStateless()) {
            mv.visitFieldInsn(178, this.lambdaClass, SINGLETON_FIELD_NAME, this.singletonFieldDesc());
            mv.visitInsn(176);
        } else {
            mv.visitTypeInsn(187, this.lambdaClass);
            mv.visitInsn(89);
            int varIndex = 0;
            for (Type type : this.constructor.getArgumentTypes()) {
                mv.visitVarInsn(type.getOpcode(21), varIndex);
                varIndex += type.getSize();
            }
            mv.visitMethodInsn(183, this.lambdaClass, "<init>", this.constructor.getDescriptor(), false);
            mv.visitInsn(176);
        }
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private String singletonFieldDesc() {
        return "L" + this.lambdaClass + ";";
    }

    private boolean isStateless() {
        return this.constructor.getArgumentTypes().length == 0;
    }

    private class CallPrivateImplMethodsViaAccessMethods
    extends MethodVisitor {
        public CallPrivateImplMethodsViaAccessMethods(MethodVisitor next) {
            super(327680, next);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (owner.equals(BackportLambdaClass.this.implMethod.getOwner()) && name.equals(BackportLambdaClass.this.implMethod.getName()) && desc.equals(BackportLambdaClass.this.implMethod.getDesc())) {
                super.visitMethodInsn(Handles.getOpcode(BackportLambdaClass.this.accessMethod), BackportLambdaClass.this.accessMethod.getOwner(), BackportLambdaClass.this.accessMethod.getName(), BackportLambdaClass.this.accessMethod.getDesc(), BackportLambdaClass.this.accessMethod.getTag() == 9);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private static class RemoveMagicLambdaConstructorCall
    extends MethodVisitor {
        public RemoveMagicLambdaConstructorCall(MethodVisitor next) {
            super(327680, next);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 183 && owner.equals("java/lang/invoke/MagicLambdaImpl") && name.equals("<init>") && desc.equals("()V")) {
                owner = BackportLambdaClass.JAVA_LANG_OBJECT;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

