/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.lambdas.LambdaFactoryMethod;
import net.orfjackal.retrolambda.lambdas.LambdaNaming;
import net.orfjackal.retrolambda.lambdas.LambdaReifier;
import net.orfjackal.retrolambda.lambdas.Types;
import net.orfjackal.retrolambda.util.Bytecode;
import net.orfjackal.retrolambda.util.Flags;

public class BackportLambdaInvocations
extends ClassVisitor {
    private int classAccess;
    private String className;
    private final Map<Handle, Handle> lambdaAccessToImplMethods = new LinkedHashMap<Handle, Handle>();

    public BackportLambdaInvocations(ClassVisitor next) {
        super(327680, next);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        BackportLambdaInvocations.resetLambdaClassSequenceNumber();
        this.classAccess = access;
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private static void resetLambdaClassSequenceNumber() {
        try {
            Field counterField = Class.forName("java.lang.invoke.InnerClassLambdaMetafactory").getDeclaredField("counter");
            counterField.setAccessible(true);
            AtomicInteger counter = (AtomicInteger)counterField.get(null);
            counter.set(0);
        }
        catch (Throwable t) {
            System.out.println("WARNING: Failed to start class numbering from one. Don't worry, it's cosmetic, but please file a bug report and tell on which JDK version this happened.");
            t.printStackTrace(System.out);
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (LambdaNaming.isDeserializationHook(access, name, desc)) {
            return null;
        }
        return new InvokeDynamicInsnConverter(super.visitMethod(access, name, desc, signature, exceptions));
    }

    Handle getLambdaAccessMethod(Handle implMethod) {
        if (!implMethod.getOwner().equals(this.className)) {
            return implMethod;
        }
        if (Flags.hasFlag(this.classAccess, 512)) {
            return implMethod;
        }
        String name = "access$lambda$" + this.lambdaAccessToImplMethods.size();
        String desc = implMethod.getTag() == 6 ? implMethod.getDesc() : Types.prependArgumentType(Type.getType("L" + this.className + ";"), implMethod.getDesc());
        Handle accessMethod = new Handle(6, this.className, name, desc);
        this.lambdaAccessToImplMethods.put(accessMethod, implMethod);
        return accessMethod;
    }

    @Override
    public void visitEnd() {
        for (Map.Entry<Handle, Handle> entry : this.lambdaAccessToImplMethods.entrySet()) {
            Handle accessMethod = entry.getKey();
            Handle implMethod = entry.getValue();
            Bytecode.generateDelegateMethod(this.cv, 4104, accessMethod, implMethod);
        }
        super.visitEnd();
    }

    private static Class<?> loadClass(String className) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.loadClass(className.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class InvokeDynamicInsnConverter
    extends MethodVisitor {
        public InvokeDynamicInsnConverter(MethodVisitor next) {
            super(327680, next);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory")) {
                this.backportLambda(name, Type.getType(desc), bsm, bsmArgs);
            } else {
                super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
            }
        }

        private void backportLambda(String invokedName, Type invokedType, Handle bsm, Object[] bsmArgs) {
            Class invoker = BackportLambdaInvocations.loadClass(BackportLambdaInvocations.this.className);
            Handle implMethod = (Handle)bsmArgs[1];
            Handle accessMethod = BackportLambdaInvocations.this.getLambdaAccessMethod(implMethod);
            LambdaFactoryMethod factory = LambdaReifier.reifyLambdaClass(implMethod, accessMethod, invoker, invokedName, invokedType, bsm, bsmArgs);
            super.visitMethodInsn(184, factory.getOwner(), factory.getName(), factory.getDesc(), false);
        }
    }
}

