/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import net.orfjackal.retrolambda.Transformers;
import net.orfjackal.retrolambda.asm.ClassReader;
import net.orfjackal.retrolambda.files.ClassSaver;
import net.orfjackal.retrolambda.lambdas.LambdaReifier;

public class LambdaClassSaver {
    private final ClassSaver saver;
    private final Transformers transformers;

    public LambdaClassSaver(ClassSaver saver, Transformers transformers) {
        this.saver = saver;
        this.transformers = transformers;
    }

    public void saveIfLambda(String className, byte[] bytecode) {
        if (LambdaReifier.isLambdaClassToReify(className)) {
            this.reifyLambdaClass(className, bytecode);
        }
    }

    private void reifyLambdaClass(String className, byte[] bytecode) {
        try {
            System.out.println("Saving lambda class: " + className);
            this.saver.save(this.transformers.backportLambdaClass(new ClassReader(bytecode)));
        }
        catch (Throwable t) {
            System.out.println("ERROR: Failed to backport lambda class: " + className);
            t.printStackTrace(System.out);
        }
    }
}

