/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.lambdas.LambdaFactoryMethod;
import net.orfjackal.retrolambda.lambdas.LambdaNaming;
import net.orfjackal.retrolambda.lambdas.Types;

public class LambdaReifier {
    private static final BlockingDeque<Handle> currentLambdaImplMethod = new LinkedBlockingDeque<Handle>(1);
    private static final BlockingDeque<Handle> currentLambdaAccessMethod = new LinkedBlockingDeque<Handle>(1);
    private static final BlockingDeque<Class<?>> currentInvoker = new LinkedBlockingDeque(1);
    private static final BlockingDeque<Type> currentInvokedType = new LinkedBlockingDeque<Type>(1);
    private static final BlockingDeque<String> currentLambdaClass = new LinkedBlockingDeque<String>(1);

    public static LambdaFactoryMethod reifyLambdaClass(Handle lambdaImplMethod, Handle lambdaAccessMethod, Class<?> invoker, String invokedName, Type invokedType, Handle bsm, Object[] bsmArgs) {
        try {
            LambdaReifier.setLambdaImplMethod(lambdaImplMethod);
            LambdaReifier.setLambdaAccessMethod(lambdaAccessMethod);
            LambdaReifier.setInvoker(invoker);
            LambdaReifier.setInvokedType(invokedType);
            LambdaReifier.callBootstrapMethod(invoker, invokedName, invokedType, bsm, bsmArgs);
            LambdaFactoryMethod lambdaFactoryMethod = LambdaReifier.getLambdaFactoryMethod();
            return lambdaFactoryMethod;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            LambdaReifier.resetGlobals();
        }
    }

    private static void setLambdaImplMethod(Handle lambdaImplMethod) {
        currentLambdaImplMethod.push(lambdaImplMethod);
    }

    private static void setLambdaAccessMethod(Handle lambdaAccessMethod) {
        currentLambdaAccessMethod.push(lambdaAccessMethod);
    }

    private static void setInvoker(Class<?> lambdaInvoker) {
        currentInvoker.push(lambdaInvoker);
    }

    private static void setInvokedType(Type invokedType) {
        currentInvokedType.push(invokedType);
    }

    public static void setLambdaClass(String lambdaClass) {
        currentLambdaClass.push(lambdaClass);
    }

    public static boolean isLambdaClassToReify(String className) {
        Class invoker = (Class)currentInvoker.peekFirst();
        return invoker != null && className.startsWith(Type.getInternalName(invoker)) && LambdaNaming.LAMBDA_CLASS.matcher(className).matches();
    }

    public static Handle getLambdaImplMethod() {
        return (Handle)currentLambdaImplMethod.getFirst();
    }

    public static Handle getLambdaAccessMethod() {
        return (Handle)currentLambdaAccessMethod.getFirst();
    }

    public static LambdaFactoryMethod getLambdaFactoryMethod() {
        String lambdaClass = (String)currentLambdaClass.getFirst();
        Type invokedType = (Type)currentInvokedType.getFirst();
        return new LambdaFactoryMethod(lambdaClass, invokedType);
    }

    private static void resetGlobals() {
        currentLambdaImplMethod.clear();
        currentLambdaAccessMethod.clear();
        currentInvoker.clear();
        currentInvokedType.clear();
        currentLambdaClass.clear();
    }

    private static CallSite callBootstrapMethod(Class<?> invoker, String invokedName, Type invokedType, Handle bsm, Object[] bsmArgs) throws Throwable {
        ClassLoader cl = invoker.getClassLoader();
        MethodHandles.Lookup caller = LambdaReifier.getLookup(invoker);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(caller);
        args.add(invokedName);
        args.add(Types.toMethodType(invokedType, cl));
        for (Object arg : bsmArgs) {
            args.add(Types.asmToJdkType(arg, cl, caller));
        }
        MethodHandle bootstrapMethod = Types.toMethodHandle(bsm, cl, caller);
        return (CallSite)bootstrapMethod.invokeWithArguments(args);
    }

    private static MethodHandles.Lookup getLookup(Class<?> targetClass) throws Exception {
        Constructor ctor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
        ctor.setAccessible(true);
        return (MethodHandles.Lookup)ctor.newInstance(targetClass);
    }
}

