/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.util;

import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.lambdas.Handles;

public class Bytecode {
    public static void generateDelegateMethod(ClassVisitor cv, int access, Handle method, Handle target) {
        MethodVisitor mv = cv.visitMethod(access, method.getName(), method.getDesc(), null, null);
        mv.visitCode();
        Type[] args = Bytecode.longest(Type.getArgumentTypes(method.getDesc()), Type.getArgumentTypes(target.getDesc()));
        int varIndex = 0;
        for (Type arg : args) {
            mv.visitVarInsn(arg.getOpcode(21), varIndex);
            varIndex += arg.getSize();
        }
        mv.visitMethodInsn(Handles.getOpcode(target), target.getOwner(), target.getName(), target.getDesc(), target.getTag() == 9);
        mv.visitInsn(Type.getReturnType(method.getDesc()).getOpcode(172));
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private static Type[] longest(Type[] t1, Type[] t2) {
        return t1.length > t2.length ? t1 : t2;
    }

    public static String prependArgumentType(String desc, Type type) {
        Type returnType = Type.getReturnType(desc);
        Type[] args = Type.getArgumentTypes(desc);
        Type[] newArgs = new Type[args.length + 1];
        newArgs[0] = type;
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return Type.getMethodDescriptor(returnType, newArgs);
    }
}

