/*
 * Decompiled with CFR 0.152.
 */
package org.moe.retrolambda.natj;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.orfjackal.retrolambda.asm.AnnotationVisitor;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import org.moe.retrolambda.natj.AnnotationHelper;
import org.moe.retrolambda.natj.NatJRuntime;

public class AddMissingAnnotations
extends ClassVisitor {
    public static final boolean DEBUG = false;
    private boolean skip = false;
    private String[] interfaces;
    private String superName;
    private String className;

    public AddMissingAnnotations(ClassVisitor next) {
        super(327680, next);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.superName = superName;
        this.interfaces = interfaces;
        this.skip = name.startsWith("org/moe/natj/");
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, final String methodName, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, methodName, desc, signature, exceptions);
        if (this.skip) {
            return visitor;
        }
        Method _parent = null;
        try {
            _parent = NatJRuntime.getParentImplementation(this.superName, this.interfaces, methodName, desc);
        }
        catch (Throwable ex) {
            System.out.println("Warning: failed to locate parent method implementation for " + this.className + "." + methodName + desc);
        }
        final Method parent = _parent;
        if (parent == null) {
            return visitor;
        }
        AddMissingAnnotations.debugPrint("Updating method from '" + parent.toGenericString() + "'");
        final AnnotationHelper methodHelper = new AnnotationHelper(parent.getDeclaredAnnotations(), true);
        final ArrayList<AnnotationHelper> paramHelpers = new ArrayList<AnnotationHelper>();
        for (Annotation[] annotations : parent.getParameterAnnotations()) {
            paramHelpers.add(new AnnotationHelper(annotations, true));
        }
        return new MethodVisitor(327680, visitor){
            boolean isVisiting;
            {
                super(x0, x1);
                this.isVisiting = true;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (this.isVisiting) {
                    methodHelper.add(desc);
                }
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                if (this.isVisiting) {
                    ((AnnotationHelper)paramHelpers.get(parameter)).add(desc);
                }
                return super.visitParameterAnnotation(parameter, desc, visible);
            }

            @Override
            public void visitCode() {
                this.injectAnnotations();
                super.visitCode();
            }

            @Override
            public void visitEnd() {
                this.injectAnnotations();
                super.visitEnd();
            }

            private void injectAnnotations() {
                if (this.isVisiting) {
                    this.isVisiting = false;
                    if (!methodHelper.hasSelectorAnnotation()) {
                        this._injectAnnotations();
                        System.out.println("Injected NatJ annotations into " + AddMissingAnnotations.this.className + "." + methodName);
                    }
                }
            }

            private void _injectAnnotations() {
                methodHelper.validate(AddMissingAnnotations.this.className + "." + methodName, -1);
                for (Class<?> cls : methodHelper.getInjectList()) {
                    this.injectAnnotation(-1, parent, cls);
                }
                if (paramHelpers.size() != parent.getParameterCount()) {
                    throw new IllegalStateException();
                }
                int i = 0;
                for (AnnotationHelper paramHelper : paramHelpers) {
                    paramHelper.validate(AddMissingAnnotations.this.className + "." + methodName, i);
                    for (Class<?> cls : paramHelper.getInjectList()) {
                        this.injectAnnotation(i, parent.getParameters()[i], cls);
                    }
                    ++i;
                }
            }

            private void injectAnnotation(int index, AnnotatedElement parent2, Class<?> cls) {
                Object annotation = parent2.getAnnotation(cls);
                Method[] fields = cls.getDeclaredMethods();
                if (annotation != null) {
                    String annClsName = annotation.annotationType().getName();
                    AddMissingAnnotations.debugPrint("Injecting " + annClsName, 1);
                    String annName = annClsName.replaceAll("\\.", "/");
                    AnnotationVisitor av = index == -1 ? this.visitAnnotation("L" + annName + ";", true) : this.visitParameterAnnotation(index, "L" + annName + ";", true);
                    for (Method field : fields) {
                        try {
                            field.setAccessible(true);
                            String fldName = field.getName();
                            Object fldValue = field.invoke(annotation, new Object[0]);
                            fldValue = this.convertClassToType(fldValue);
                            if (fldValue.getClass().isArray()) {
                                Object[] arr = (Object[])fldValue;
                                AnnotationVisitor av2 = av.visitArray(fldName);
                                for (Object obj : arr) {
                                    av2.visit(null, obj);
                                }
                                av2.visitEnd();
                                continue;
                            }
                            av.visit(fldName, fldValue);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IllegalArgumentException e) {
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }

            private Object convertClassToType(Object value) {
                if (value instanceof Class) {
                    value = Type.getType((Class)value);
                }
                if (!value.getClass().isArray()) {
                    return value;
                }
                Object[] values = (Object[])value;
                if (values.getClass().getComponentType() == Class.class) {
                    Type[] types = new Type[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        types[i] = (Type)this.convertClassToType(values[i]);
                    }
                    return types;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.convertClassToType(values[i]);
                }
                return values;
            }
        };
    }

    private static void debugPrint(String value, int depth) {
        AddMissingAnnotations.debugPrint(value, "", depth);
    }

    private static void debugPrint(String value, String prefix, int depth) {
    }

    private static void debugPrint(String value) {
    }
}

