/*
 * Decompiled with CFR 0.152.
 */
package org.moe.retrolambda.natj;

import java.util.ListIterator;
import net.orfjackal.retrolambda.asm.AnnotationVisitor;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.tree.AbstractInsnNode;
import net.orfjackal.retrolambda.asm.tree.InsnList;
import net.orfjackal.retrolambda.asm.tree.MethodInsnNode;
import net.orfjackal.retrolambda.asm.tree.MethodNode;
import org.moe.retrolambda.natj.NatJRuntime;

public class AddMissingNatJRegister
extends ClassVisitor {
    public static final boolean DEBUG = false;
    private static final int NATJREG_UNKNOWN = -1;
    private static final int NATJREG_LEAVE_ALONE = 2;
    private static final int NATJREG_INSERT_FIRST = 3;
    private boolean skip = false;
    private boolean visit = false;
    private int action = -1;
    private MethodNode CLI;
    private String name;

    public AddMissingNatJRegister(ClassVisitor next) {
        super(327680, next);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = name;
        this.skip = name.startsWith("org/moe/natj/");
        if (!this.skip) {
            this.visit = NatJRuntime.isNativeObjectDescendant(superName);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!this.skip && !this.visit) {
            this.visit = "Lorg/moe/natj/general/ann/Runtime;".equals(desc);
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.skip || !this.visit) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (this.CLI != null) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if ("<clinit>".equals(name)) {
            this.CLI = new MethodNode(access, name, desc, signature, exceptions);
            return this.CLI;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (!this.visit) {
            super.visitEnd();
            return;
        }
        if (this.CLI != null) {
            this.action = 3;
            InsnList insts = this.CLI.instructions;
            ListIterator<AbstractInsnNode> it = insts.iterator();
            int idx = 0;
            while (it.hasNext()) {
                AbstractInsnNode n = it.next();
                if (n instanceof MethodInsnNode) {
                    MethodInsnNode i = (MethodInsnNode)n;
                    if (NatJRuntime.isNatJRegisterInsn(i.owner, i.name, i.desc)) {
                        this.action = 2;
                        AddMissingNatJRegister.debugPrint("Found NatJ.register() among instructions");
                        break;
                    }
                }
                ++idx;
            }
            if (idx == insts.size()) {
                this.action = 3;
                AddMissingNatJRegister.debugPrint("Didn't find NatJ.register() among instructions");
            }
            MethodVisitor mv = super.visitMethod(this.CLI.access, this.CLI.name, this.CLI.desc, this.CLI.signature, this.CLI.exceptions.toArray(new String[0]));
            if (this.action == 3) {
                mv.visitCode();
                mv.visitMethodInsn(184, "org/moe/natj/general/NatJ", "register", "()V", false);
                this.CLI.accept(mv);
                System.out.println("Injected NatJ.register() into " + this.name);
            } else {
                mv.visitCode();
                this.CLI.accept(mv);
            }
        } else {
            MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            mv.visitMethodInsn(184, "org/moe/natj/general/NatJ", "register", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
            System.out.println("Injected NatJ.register() into " + this.name);
        }
        super.visitEnd();
    }

    private static void debugPrint(String value) {
    }
}

