/*
 * Decompiled with CFR 0.152.
 */
package org.moe.retrolambda.natj;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.moe.retrolambda.natj.NatJRuntime;

public class AnnotationHelper {
    public static final boolean DEBUG = false;
    private final Annotation[] parentAnnotations;
    private final boolean hasOptionals;
    private final ArrayList<Class<?>> annotations = new ArrayList();

    public AnnotationHelper(Annotation[] parent, boolean hasOptionals) {
        this.parentAnnotations = parent;
        this.hasOptionals = hasOptionals;
    }

    public void add(String ann) {
        if (ann == null) {
            throw new NullPointerException();
        }
        this.add(NatJRuntime.getClassFor(ann.substring(1, ann.length() - 1)));
    }

    public void add(Class<?> ann) {
        if (ann == null) {
            throw new NullPointerException();
        }
        this.annotations.add(ann);
    }

    public boolean hasSelectorAnnotation() {
        return this.annotations.contains(NatJRuntime.Annotations.SELECTOR);
    }

    private ArrayList<Class<?>> getNewCompleteList() {
        return new ArrayList(this.hasOptionals ? NatJRuntime.Annotations.OPTIONALS : NatJRuntime.Annotations.NON_OPTIONALS);
    }

    private ArrayList<Class<?>> getNewRetainList() {
        ArrayList list = new ArrayList();
        for (Annotation annotation : this.parentAnnotations) {
            list.add(annotation.annotationType());
        }
        return list;
    }

    public ArrayList<Class<?>> getInjectList() {
        ArrayList<Class<Class<?>>> list = this.getNewCompleteList();
        list.retainAll(this.getNewRetainList());
        list.removeAll(this.annotations);
        return list;
    }

    public void validate(String desc, int index) {
        ArrayList parentAnns = new ArrayList();
        for (Annotation ann : this.parentAnnotations) {
            parentAnns.add(ann.getClass());
        }
        ArrayList definedAnns = new ArrayList(this.annotations);
        ArrayList allAnns = new ArrayList(definedAnns);
        allAnns.removeAll(parentAnns);
        allAnns.addAll(parentAnns);
        boolean isReturn = index == -1;
        AnnotationHelper.debugPrint("VA--> " + desc);
        this.validateAnnotationTypes(desc, allAnns, isReturn);
        this.validateAnnotationCollision(desc, allAnns, isReturn);
    }

    private void validateAnnotationTypes(String desc, ArrayList<Class<?>> allAnns, boolean isReturn) {
        List<Class<?>> enabledAnns = isReturn ? NatJRuntime.Annotations.RETURN_ANNS : NatJRuntime.Annotations.PARAM_ANNS;
        for (Class<?> cls : allAnns) {
            if (enabledAnns.contains(cls) || !NatJRuntime.Annotations.ALL_ANNS.contains(cls)) continue;
            throw new RuntimeException("Annotation " + cls.getName() + " is not allowed on " + (isReturn ? "return type/method" : "parameter") + "! Method: " + desc);
        }
    }

    private void validateAnnotationCollision(String desc, ArrayList<Class<?>> allAnns, boolean b) {
        for (List<Class<?>> anns : NatJRuntime.Annotations.COLLIDING_ANNS) {
            int count = 0;
            for (Class<?> ann : allAnns) {
                AnnotationHelper.debugPrint("VAC: " + ann.getName(), 1);
                count += anns.contains(ann) ? 1 : 0;
            }
            AnnotationHelper.debugPrint("VAC Count: " + count, 1);
            if (count <= 1) continue;
            ArrayList tmp = new ArrayList(allAnns);
            tmp.retainAll(anns);
            throw new RuntimeException("Annotations " + tmp + " can't be specified at the same time! Method: " + desc);
        }
    }

    private static void debugPrint(String value, int depth) {
        AnnotationHelper.debugPrint(value, "", depth);
    }

    private static void debugPrint(String value, String prefix, int depth) {
    }

    private static void debugPrint(String value) {
    }
}

