/*
 * Decompiled with CFR 0.152.
 */
package org.moe.retrolambda.natj;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class NatJRuntime {
    public static final boolean DEBUG = false;
    public static final String NATJ_NATIVE_OBJECT = "org.moe.natj.general.NativeObject";
    public static final String NATJ_OWNER = "org/moe/natj/general/NatJ";
    public static final String NATJ_REGISTER_DESC = "()V";
    public static final String NATJ_REGISTER_NAME = "register";
    public static final String RUNTIME_ANNOTATION_DESC = "Lorg/moe/natj/general/ann/Runtime;";

    public static boolean isNatJRegisterInsn(String owner, String name, String desc) {
        return NATJ_OWNER.equals(owner) && NATJ_REGISTER_NAME.equals(name) && NATJ_REGISTER_DESC.equals(desc);
    }

    public static boolean isNativeObjectDescendant(String superName) {
        try {
            NatJRuntime.debugPrint("isNativeObjectDescendant: " + superName);
            Class<?> cls = NatJRuntime.getClassFor(superName);
            int depth = 0;
            do {
                NatJRuntime.debugPrint(cls.getName(), ++depth);
                if (!NATJ_NATIVE_OBJECT.equals(cls.getName())) continue;
                return true;
            } while ((cls = NatJRuntime.getSuper(cls)) != null);
        }
        catch (Throwable ex) {
            System.out.println("Warning: failed to process class hierarchy, assuming class '" + superName + "' is not NativeObject descendant");
        }
        return false;
    }

    public static Method getParentImplementation(String superName, String[] interfaces, String name, String desc) {
        NatJRuntime.debugPrint("getRootImplementation: " + superName + ", " + name + ", " + desc);
        Class<?> superCls = null;
        Class<?> cls = NatJRuntime.getClassFor(superName);
        int depth = 0;
        do {
            NatJRuntime.debugPrint(cls.getName(), ++depth);
            Method method = NatJRuntime.getDeclaredMethod(cls, name, NatJRuntime.getParamClasses(desc));
            if (NatJRuntime.hasSelectorAnn(method)) {
                NatJRuntime.debugPrint("Match " + method, depth + 2);
                return method;
            }
            HashSet itfs = new HashSet();
            if (superCls == null) {
                for (int i = 0; i < interfaces.length; ++i) {
                    NatJRuntime.collectInterfaces(NatJRuntime.getClassFor(interfaces[i]), itfs);
                }
            } else {
                for (Class<?> itf : superCls.getInterfaces()) {
                    NatJRuntime.collectInterfaces(itf, itfs);
                }
            }
            for (Class clazz : itfs) {
                method = NatJRuntime.getDeclaredMethod(clazz, name, NatJRuntime.getParamClasses(desc));
                if (!NatJRuntime.hasSelectorAnn(method)) continue;
                NatJRuntime.debugPrint("Match " + method, depth + 2);
                return method;
            }
        } while ((superCls = cls) != null && (cls = NatJRuntime.getSuper(cls)) != null);
        return null;
    }

    private static void collectInterfaces(Class<?> classFor, HashSet<Class<?>> itfs) {
        itfs.add(classFor);
        for (Class<?> inner : classFor.getInterfaces()) {
            if (itfs.contains(inner)) continue;
            NatJRuntime.collectInterfaces(inner, itfs);
        }
    }

    private static boolean hasSelectorAnn(Method method) {
        Annotation[] annotations;
        if (method == null) {
            return false;
        }
        for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
            if (!Annotations.SELECTOR.equals(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method method;
        if (cls == null) {
            return null;
        }
        try {
            method = cls.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        return method;
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static Class<?> getSuper(Class<?> cls) {
        return cls.getSuperclass();
    }

    public static Class<?> getClassFor(String cls) {
        try {
            return NatJRuntime.getClassLoader().loadClass(cls.replaceAll("[\\/]", "."));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?>[] getParamClasses(String desc) {
        if (desc == null) {
            throw new IllegalArgumentException();
        }
        if (!desc.startsWith("(")) {
            throw new IllegalArgumentException();
        }
        ArrayList<Class<Byte>> classes = new ArrayList<Class<Byte>>();
        int start = 1;
        int dim = 0;
        while (desc.codePointAt(start) != 41) {
            Class<Comparable<Byte>> cls = null;
            int codePoint = desc.codePointAt(start);
            switch (codePoint) {
                case 66: {
                    cls = Byte.TYPE;
                    ++start;
                    break;
                }
                case 67: {
                    cls = Character.TYPE;
                    ++start;
                    break;
                }
                case 68: {
                    cls = Double.TYPE;
                    ++start;
                    break;
                }
                case 70: {
                    cls = Float.TYPE;
                    ++start;
                    break;
                }
                case 73: {
                    cls = Integer.TYPE;
                    ++start;
                    break;
                }
                case 74: {
                    cls = Long.TYPE;
                    ++start;
                    break;
                }
                case 83: {
                    cls = Short.TYPE;
                    ++start;
                    break;
                }
                case 90: {
                    cls = Boolean.TYPE;
                    ++start;
                    break;
                }
                case 91: {
                    ++dim;
                    ++start;
                    break;
                }
                case 76: {
                    int end = desc.indexOf(59, ++start);
                    if (end == -1) {
                        throw new IllegalStateException();
                    }
                    cls = NatJRuntime.getClassFor(desc.substring(start, end));
                    start = end + 1;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (cls == null) continue;
            while (dim > 0) {
                --dim;
                cls = Array.newInstance(cls, 0).getClass();
            }
            classes.add(cls);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static void debugPrint(String value, int depth) {
        NatJRuntime.debugPrint(value, "", depth);
    }

    private static void debugPrint(String value, String prefix, int depth) {
    }

    private static void debugPrint(String value) {
    }

    public static final class Annotations {
        public static final Class<?> BY_VALUE = NatJRuntime.getClassFor("org.moe.natj.general.ann.ByValue");
        public static final Class<?> MAPPED = NatJRuntime.getClassFor("org.moe.natj.general.ann.Mapped");
        public static final Class<?> MAPPED_RETURN = NatJRuntime.getClassFor("org.moe.natj.general.ann.MappedReturn");
        public static final Class<?> NFLOAT = NatJRuntime.getClassFor("org.moe.natj.general.ann.NFloat");
        public static final Class<?> NINT = NatJRuntime.getClassFor("org.moe.natj.general.ann.NInt");
        public static final Class<?> NUINT = NatJRuntime.getClassFor("org.moe.natj.general.ann.NUInt");
        public static final Class<?> OWNED = NatJRuntime.getClassFor("org.moe.natj.general.ann.Owned");
        public static final Class<?> REFERENCE_INFO = NatJRuntime.getClassFor("org.moe.natj.general.ann.ReferenceInfo");
        public static final Class<?> FUNCTION_PTR = NatJRuntime.getClassFor("org.moe.natj.c.ann.FunctionPtr");
        public static final Class<?> IBACTION = NatJRuntime.getClassFor("org.moe.natj.objc.ann.IBAction");
        public static final Class<?> IBOUTLET = NatJRuntime.getClassFor("org.moe.natj.objc.ann.IBOutlet");
        public static final Class<?> IBOUTLET_COLLECTION = NatJRuntime.getClassFor("org.moe.natj.objc.ann.IBOutletCollection");
        public static final Class<?> NOT_IMPLEMENTED = NatJRuntime.getClassFor("org.moe.natj.objc.ann.NotImplemented");
        public static final Class<?> OBJC_BLOCK = NatJRuntime.getClassFor("org.moe.natj.objc.ann.ObjCBlock");
        public static final Class<?> SELECTOR = NatJRuntime.getClassFor("org.moe.natj.objc.ann.Selector");
        public static final List<Class<?>> OPTIONALS = Collections.unmodifiableList(Arrays.asList(BY_VALUE, MAPPED, MAPPED_RETURN, NFLOAT, NINT, NUINT, OWNED, REFERENCE_INFO, FUNCTION_PTR, IBACTION, IBOUTLET, IBOUTLET_COLLECTION, NOT_IMPLEMENTED, OBJC_BLOCK, SELECTOR));
        public static final List<Class<?>> NON_OPTIONALS = Collections.unmodifiableList(Arrays.asList(BY_VALUE, MAPPED, MAPPED_RETURN, NFLOAT, NINT, NUINT, OWNED, REFERENCE_INFO, FUNCTION_PTR, IBACTION, IBOUTLET, IBOUTLET_COLLECTION, OBJC_BLOCK, SELECTOR));
        public static final List<List<Class<?>>> COLLIDING_ANNS;
        public static final List<Class<?>> ALL_ANNS;
        public static final List<Class<?>> RETURN_ANNS;
        public static final List<Class<?>> PARAM_ANNS;

        private Annotations() {
        }

        static {
            ArrayList<List<Class>> lists = new ArrayList<List<Class>>();
            lists.add(Collections.unmodifiableList(Arrays.asList(NFLOAT, NINT, NUINT)));
            lists.add(Collections.unmodifiableList(Arrays.asList(FUNCTION_PTR, OBJC_BLOCK)));
            lists.add(Collections.unmodifiableList(Arrays.asList(IBACTION, IBOUTLET, IBOUTLET_COLLECTION)));
            lists.add(Collections.unmodifiableList(Arrays.asList(MAPPED, MAPPED_RETURN)));
            COLLIDING_ANNS = Collections.unmodifiableList(lists);
            ALL_ANNS = Collections.unmodifiableList(Arrays.asList(BY_VALUE, MAPPED, MAPPED_RETURN, NFLOAT, NINT, NUINT, OWNED, REFERENCE_INFO, FUNCTION_PTR, IBACTION, IBOUTLET, IBOUTLET_COLLECTION, NOT_IMPLEMENTED, OBJC_BLOCK, SELECTOR));
            RETURN_ANNS = Collections.unmodifiableList(Arrays.asList(BY_VALUE, MAPPED_RETURN, NFLOAT, NINT, NUINT, OWNED, REFERENCE_INFO, FUNCTION_PTR, IBACTION, IBOUTLET, IBOUTLET_COLLECTION, NOT_IMPLEMENTED, OBJC_BLOCK, SELECTOR));
            PARAM_ANNS = Collections.unmodifiableList(Arrays.asList(BY_VALUE, MAPPED, NFLOAT, NINT, NUINT, OWNED, REFERENCE_INFO, FUNCTION_PTR, OBJC_BLOCK));
        }
    }
}

