/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class PasswordEntry
implements Serializable {
    public static final char charToFill = '\u0000';
    private char[] value;

    public PasswordEntry() {
    }

    public PasswordEntry(char[] key) {
        this.set(key);
    }

    public PasswordEntry(String key) throws Exception {
        this.set(key);
    }

    public static void fillString(String target, char value) throws Exception {
        String fieldName = "value";
        if (target == null || target.isEmpty()) {
            return;
        }
        try {
            Field field = String.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            char[] chars = (char[])field.get(target);
            Arrays.fill(chars, value);
        }
        catch (NoSuchFieldException e1) {
            throw new Exception("Failed to get field with name: " + fieldName + "\n" + e1.getMessage());
        }
        catch (IllegalAccessException e2) {
            throw new Exception("Failed to get value from field with name: " + target + "\n" + e2.getMessage());
        }
    }

    public static void clean(byte[] target) {
        if (target != null) {
            Arrays.fill(target, (byte)0);
        }
    }

    public static void clean(char[] target) {
        if (target != null) {
            Arrays.fill(target, '\u0000');
        }
    }

    public static void clean(String target) throws Exception {
        PasswordEntry.fillString(target, '\u0000');
    }

    public void set(char[] value) {
        this.Clean();
        if (value == null || value.length == 0) {
            return;
        }
        this.value = value;
    }

    public void set(String value) throws Exception {
        this.Clean();
        if (value == null || value.isEmpty()) {
            return;
        }
        this.value = value.toCharArray();
        PasswordEntry.fillString(value, '\u0000');
    }

    public char[] get() {
        return this.value;
    }

    public void Clean() {
        if (this.value != null) {
            Arrays.fill(this.value, '\u0000');
        }
    }

    public byte[] getByteArray() {
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(CharBuffer.wrap(this.value));
        byte[] resultBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(resultBytes);
        Arrays.fill(byteBuffer.array(), (byte)0);
        return resultBytes;
    }
}

