/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common;

public class Port {
    private final short port;

    public Port(short port) {
        this.port = port;
    }

    public static Port parse(String string) {
        int port;
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.matches("[\\d]+") && (port = Integer.parseInt(string)) >= 0 && port <= 65535) {
            return new Port((short)(port & 0xFFFF));
        }
        throw new IllegalArgumentException("[0-65535]");
    }

    public short getShortPort() {
        return this.port;
    }

    public int getPort() {
        return this.port & 0xFFFF;
    }

    public String toString() {
        return Integer.toString(this.getPort());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Port port1 = (Port)o;
        return this.port == port1.port;
    }

    public int hashCode() {
        return this.port;
    }
}

