/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common;

public class ProxyPort {
    private final short localPort;
    private final short remotePort;

    public ProxyPort(short localPort, short remotePort) {
        this.localPort = localPort;
        this.remotePort = remotePort;
    }

    public static ProxyPort parse(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.matches("[\\d]+")) {
            int port = Integer.parseInt(string);
            if (port >= 0 && port <= 65535) {
                return new ProxyPort((short)(port & 0xFFFF), (short)(port & 0xFFFF));
            }
        } else if (string.matches("[\\d]+:[\\d]+")) {
            int spl = string.indexOf(58);
            int local = Integer.parseInt(string.substring(0, spl));
            int remote = Integer.parseInt(string.substring(spl + 1));
            if (local >= 0 && local <= 65535 && remote >= 0 && remote <= 65535) {
                return new ProxyPort((short)(local & 0xFFFF), (short)(remote & 0xFFFF));
            }
        }
        throw new IllegalArgumentException("[0-65535] or [0-65535]:[0-65535]");
    }

    public short getShortLocalPort() {
        return this.localPort;
    }

    public short getShortRemotePort() {
        return this.remotePort;
    }

    public int getLocalPort() {
        return this.localPort & 0xFFFF;
    }

    public int getRemotePort() {
        return this.remotePort & 0xFFFF;
    }

    public String toString() {
        return this.getLocalPort() + ":" + this.getRemotePort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyPort proxyPort = (ProxyPort)o;
        return this.localPort == proxyPort.localPort && this.remotePort == proxyPort.remotePort;
    }

    public int hashCode() {
        int result = this.localPort;
        result = 31 * result + this.remotePort;
        return result;
    }
}

