/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownManager
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownManager.class);
    private final Thread thread = new Thread(this);
    private final ConcurrentLinkedQueue<Runnable> runnables = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> postRunnables = new ConcurrentLinkedQueue();

    public static void register(Runnable runnable) {
        HOLDER.INSTANCE.runnables.add(runnable);
    }

    public static void registerPost(Runnable runnable) {
        HOLDER.INSTANCE.postRunnables.add(runnable);
    }

    public static void shutdown() {
        Thread killer = new Thread(HOLDER.INSTANCE);
        killer.start();
        try {
            killer.join(10000L);
        }
        catch (InterruptedException e) {
            LOG.debug("Failed to join shutdown thread");
        }
    }

    @Override
    public void run() {
        Runnable runnable;
        LOG.debug("Shutting down");
        while ((runnable = this.runnables.poll()) != null) {
            LOG.debug("Shutting down " + runnable);
            runnable.run();
        }
        while ((runnable = this.postRunnables.poll()) != null) {
            LOG.debug("Shutting down post " + runnable);
            runnable.run();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(HOLDER.INSTANCE.thread);
    }

    private static class HOLDER {
        public static final ShutdownManager INSTANCE = new ShutdownManager();

        private HOLDER() {
        }
    }
}

