/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.configuration;

import java.io.File;
import org.moe.common.configuration.ConfigurationValidationException;
import org.moe.common.utils.ArrayUtil;

public abstract class AbstractConfiguration {
    public static final String PROPERTY_NOT_DEFINED_ERROR = "Property is not defined";
    public static final String PROPERTY_CONTAINS_SPACE_ERROR = "Space character in property is not allowed";
    public static final String PROPERTY_IS_EMPTY_ERROR = "Property cannot be empty";
    public static final String PROPERTY_FILE_DOESNT_EXIST_ERROR = "Property must point to a valid file";
    public static final String PROPERTY_DIRECTORY_DOESNT_EXIST_ERROR = "Property must point to a valid directory";
    public static final String PROPERTY_VALUE_INVALID = "Property value is invalid";
    private boolean closed;

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void requireOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("configuration is closed");
        }
    }

    public abstract void validate() throws ConfigurationValidationException;

    public Object getProperty(String key) {
        throw new IllegalArgumentException("unknown key: " + key);
    }

    public void setProperty(String key, Object value) {
        throw new IllegalArgumentException("unknown key: " + key);
    }

    public Class<?> getPropertyClass(String key) {
        throw new IllegalArgumentException("unknown key: " + key);
    }

    public String[] getAllPropertyNames() {
        return new String[0];
    }

    protected final void assertNotNull(String property, Object value) throws ConfigurationValidationException {
        if (value == null) {
            throw new ConfigurationValidationException(property, PROPERTY_NOT_DEFINED_ERROR);
        }
    }

    protected final void assertNotEmpty(String property, String value) throws ConfigurationValidationException {
        if (value != null && value.length() == 0) {
            throw new ConfigurationValidationException(property, PROPERTY_IS_EMPTY_ERROR);
        }
    }

    protected final void assertNoSpace(String property, String value) throws ConfigurationValidationException {
        if (value != null && value.contains(" ")) {
            throw new ConfigurationValidationException(property, PROPERTY_CONTAINS_SPACE_ERROR);
        }
    }

    protected final void assertFileExists(String property, File value) throws ConfigurationValidationException {
        if (value == null) {
            return;
        }
        if (!value.exists() || !value.isFile()) {
            throw new ConfigurationValidationException(property, PROPERTY_FILE_DOESNT_EXIST_ERROR);
        }
    }

    protected final void assertDirectoryExists(String property, File value) throws ConfigurationValidationException {
        if (value == null) {
            return;
        }
        if (!value.exists() || !value.isDirectory()) {
            throw new ConfigurationValidationException(property, PROPERTY_DIRECTORY_DOESNT_EXIST_ERROR);
        }
    }

    protected final <T> void assertValueIsOneOf(String property, T value, T[] array) throws ConfigurationValidationException {
        if (value == null) {
            return;
        }
        if (!ArrayUtil.contains(array, value)) {
            throw new ConfigurationValidationException(property, "Property value is invalid (" + ArrayUtil.join(array, ", ") + ")");
        }
    }
}

