/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.moe.common.Port;
import org.moe.common.ProxyPort;
import org.moe.common.configuration.AbstractConfiguration;
import org.moe.common.utils.ArrayUtil;

public abstract class AbstractConfigurationAppender {
    private final AbstractConfiguration configuration;
    private final ArrayList<Option> options = new ArrayList();
    private final HashMap<String, String> optionHelps = new HashMap();
    private final HashMap<String, String> optionExamples = new HashMap();
    private boolean hasRunSetup = false;

    protected AbstractConfigurationAppender(AbstractConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
    }

    protected abstract void setup();

    protected final void addOptionWithArg(String option, String property) {
        this.options.add(new Option(option, property, false, null));
    }

    protected final void addOptionWithValue(String option, String property, Object value) {
        this.options.add(new Option(option, property, true, value));
    }

    protected final void addHelp(String property, String example, String description) {
        this.optionHelps.put(property, description);
        if (example != null && example.length() > 0) {
            this.optionExamples.put(property, "Example: " + example);
        }
    }

    public final void set(String ... options) {
        if (!this.hasRunSetup) {
            this.hasRunSetup = true;
            this.setup();
        }
        for (String option : options) {
            if ("-h".equals(option) || "--help".equals(option)) {
                this.printHelp();
                continue;
            }
            this.pushOption(option);
        }
    }

    private void printHelp() {
        System.out.println("Help");
        System.out.println("------------------");
        ArrayList<String> printedHelps = new ArrayList<String>();
        for (Option option : this.options) {
            if (printedHelps.contains(option.propertyName)) continue;
            printedHelps.add(option.propertyName);
            String desc = this.optionHelps.get(option.propertyName);
            if (desc == null) continue;
            String example = this.optionExamples.get(option.propertyName);
            ArrayList<String> args2 = new ArrayList<String>();
            args2.add(option.optionName);
            for (Option option2 : this.options) {
                if (!option.propertyName.equals(option2.propertyName) || args2.contains(option2.optionName)) continue;
                args2.add(option2.optionName);
            }
            System.out.println(ArrayUtil.join(args2, ","));
            System.out.println(this.fitInWidth(desc, 80));
            if (example != null && example.length() > 0) {
                System.out.println("        " + example);
            }
            System.out.println();
        }
    }

    private String fitInWidth(String value, int width) {
        ArrayList<String> words = new ArrayList<String>(Arrays.asList(value.split(" ")));
        StringBuilder builder = new StringBuilder(value.length() + 30);
        int linew = 4;
        builder.append("    ");
        for (String word : words) {
            if (linew + word.length() > width && linew != 4) {
                linew = 4;
                builder.append("\n    ");
            }
            builder.append(word).append(" ");
            linew += word.length() + 1;
        }
        return builder.toString();
    }

    private void pushOption(String input) {
        for (Option option : this.options) {
            try {
                Object value = this.tryGetValue(input, option);
                this.configuration.setProperty(option.propertyName, value);
                return;
            }
            catch (IOException iOException) {
            }
        }
        throw new IllegalArgumentException("Unrecognized argument '" + input + "'");
    }

    private Object tryGetValue(String value, Option option) throws IOException {
        if (!value.startsWith(option.optionName)) {
            throw new IOException();
        }
        value = value.substring(option.optionName.length());
        if (option.setsValue) {
            if (value.length() != 0) {
                throw new IOException();
            }
            return option.valueSet;
        }
        if (!value.startsWith("=")) {
            throw new IOException();
        }
        return (value = value.substring(1)).length() == 0 ? null : this.convertValue(value, option);
    }

    protected Object convertValue(String value, Option option) {
        Class<?> clazz = this.configuration.getPropertyClass(option.propertyName);
        if (clazz == String.class) {
            return value;
        }
        if (clazz == File.class) {
            return new File(value);
        }
        if (clazz == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (clazz == Byte.class) {
            return new Byte(value);
        }
        if (clazz == Short.class) {
            return new Short(value);
        }
        if (clazz == Integer.class) {
            return new Integer(value);
        }
        if (clazz == Long.class) {
            return new Long(value);
        }
        if (clazz == Float.class) {
            return new Float(value);
        }
        if (clazz == Double.class) {
            return new Double(value);
        }
        if (clazz == ProxyPort.class) {
            return ProxyPort.parse(value);
        }
        if (clazz == Port.class) {
            return Port.parse(value);
        }
        return value;
    }

    private static class Option {
        private final String optionName;
        private final String propertyName;
        private final boolean setsValue;
        private final Object valueSet;

        private Option(String optionName, String propertyName, boolean setsValue, Object valueSet) {
            if (optionName == null || propertyName == null) {
                throw new NullPointerException();
            }
            this.optionName = optionName;
            this.propertyName = propertyName;
            this.setsValue = setsValue;
            this.valueSet = valueSet;
        }
    }
}

