/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.moe.common.configuration.ConfigurationValidationException;
import org.moe.common.exec.ExecRunner;
import org.moe.common.exec.ExecRunnerBase;
import org.moe.common.exec.GradleExec;
import org.moe.common.utils.InputValidationHelper;

public class RemoteSettings {
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    public static final String USER_KEY = "user";
    public static final String KNOWHOSTS_KEY = "knownhosts";
    public static final String IDENTITY_KEY = "identity";
    public static final String KEYCHAIN_NAME_KEY = "keychain.name";
    public static final String KEYCHAIN_PASS_KEY = "keychain.pass";
    public static final String KEYCHAIN_LOCKTIMEOUT_KEY = "keychain.locktimeout";
    public static final String GRADLE_REPOSITORIES_KEY = "gradle.repositories";
    public static final String HOST_PROPERTY = "moe.remotebuild.host=";
    public static final String PORT_PROPERTY = "moe.remotebuild.port=";
    public static final String USER_PROPERTY = "moe.remotebuild.user=";
    public static final String KNOWHOSTS_PROPERTY = "moe.remotebuild.knownhosts=";
    public static final String IDENTITY_PROPERTY = "moe.remotebuild.identity=";
    public static final String KEYCHAIN_NAME_PROPERTY = "moe.remotebuild.keychain.name=";
    public static final String KEYCHAIN_PASS_PROPERTY = "moe.remotebuild.keychain.pass=";
    public static final String KEYCHAIN_LOCKTIMEOUT_PROPERTY = "moe.remotebuild.keychain.locktimeout=";
    public static final String GRADLE_REPOSITORIES_PROPERTY = "moe.remotebuild.gradle.repositories=";

    public static String test(File projectFile, Properties properties, ExecRunnerBase.ExecRunnerListener listener) {
        ArrayList<String> args2 = new ArrayList<String>();
        args2.add("moeTestRemote");
        args2.add("-Pmoe.remotebuild.properties.ignore");
        RemoteSettings.getArguments("-P", properties, args2);
        args2.add("-s");
        GradleExec exec = new GradleExec(projectFile);
        exec.getArguments().addAll(args2);
        ExecRunner runner = null;
        try {
            runner = exec.getRunner();
            if (listener != null) {
                runner.setListener(listener);
            }
        }
        catch (IOException e) {
            return "Unable run test: " + e.getMessage();
        }
        if (runner != null) {
            runner.getBuilder().directory(projectFile);
        }
        try {
            int result = runner.run(null);
            if (result != 0) {
                return "Test fail, result code: " + result;
            }
            return null;
        }
        catch (Exception e) {
            return "Unable run test: " + e.getMessage();
        }
    }

    public static void getArguments(String prefix, Properties properties, List<String> args2) {
        args2.add(prefix + HOST_PROPERTY + properties.getProperty(HOST_KEY));
        args2.add(prefix + PORT_PROPERTY + properties.getProperty(PORT_KEY));
        args2.add(prefix + USER_PROPERTY + properties.getProperty(USER_KEY));
        args2.add(prefix + KNOWHOSTS_PROPERTY + properties.getProperty(KNOWHOSTS_KEY));
        args2.add(prefix + IDENTITY_PROPERTY + properties.getProperty(IDENTITY_KEY));
        args2.add(prefix + KEYCHAIN_NAME_PROPERTY + properties.getProperty(KEYCHAIN_NAME_KEY));
        args2.add(prefix + KEYCHAIN_PASS_PROPERTY + properties.getProperty(KEYCHAIN_PASS_KEY));
        args2.add(prefix + KEYCHAIN_LOCKTIMEOUT_PROPERTY + properties.getProperty(KEYCHAIN_LOCKTIMEOUT_KEY));
        if (prefix.equals("-D")) {
            args2.add(prefix + GRADLE_REPOSITORIES_PROPERTY + "\"" + properties.getProperty(GRADLE_REPOSITORIES_KEY) + "\"");
        } else {
            args2.add(prefix + GRADLE_REPOSITORIES_PROPERTY + properties.getProperty(GRADLE_REPOSITORIES_KEY));
        }
    }

    public static Properties getProperties(String remoteHost, String remotePort, String remoteUser, String remoteKnownhosts, String remoteIdentity, String remoteKeychainName, String remoteKeychainPass, String remoteKeychainLocktimeout, String remoteGradleRepositories) {
        Properties properties = new Properties();
        properties.put(HOST_KEY, remoteHost);
        properties.put(PORT_KEY, remotePort);
        properties.put(USER_KEY, remoteUser);
        properties.put(KNOWHOSTS_KEY, remoteKnownhosts);
        properties.put(IDENTITY_KEY, remoteIdentity);
        properties.put(KEYCHAIN_NAME_KEY, remoteKeychainName);
        properties.put(KEYCHAIN_PASS_KEY, remoteKeychainPass);
        properties.put(KEYCHAIN_LOCKTIMEOUT_KEY, remoteKeychainLocktimeout);
        properties.put(GRADLE_REPOSITORIES_KEY, remoteGradleRepositories);
        return properties;
    }

    public static void validate(Properties properties) throws ConfigurationValidationException {
        String host = properties.getProperty(HOST_KEY);
        if (host == null || host.isEmpty()) {
            throw new ConfigurationValidationException(HOST_KEY, "Please enter a remote host value.");
        }
        String port = properties.getProperty(PORT_KEY);
        if (port == null || port.isEmpty()) {
            throw new ConfigurationValidationException(PORT_KEY, "Please enter a debug port");
        }
        if (!InputValidationHelper.isInteger(port)) {
            throw new ConfigurationValidationException(PORT_KEY, "Wrong remote port number, please enter a numeric value.");
        }
        String user = properties.getProperty(USER_KEY);
        if (user == null || user.isEmpty()) {
            throw new ConfigurationValidationException(USER_KEY, "Please enter a remote user value.");
        }
        String remoteKnownhosts = properties.getProperty(KNOWHOSTS_KEY);
        if (remoteKnownhosts == null || remoteKnownhosts.isEmpty()) {
            throw new ConfigurationValidationException(KNOWHOSTS_KEY, "Please enter a remote Knownhosts value.");
        }
        String remoteIdentity = properties.getProperty(IDENTITY_KEY);
        if (remoteIdentity == null || remoteIdentity.isEmpty()) {
            throw new ConfigurationValidationException(IDENTITY_KEY, "Please enter a remote Identity value.");
        }
        String remoteKeychainName = properties.getProperty(KEYCHAIN_NAME_KEY);
        if (remoteKeychainName == null || remoteKeychainName.isEmpty()) {
            throw new ConfigurationValidationException(KEYCHAIN_NAME_KEY, "Please enter a remote Keychain.name value.");
        }
        String remoteKeychainPass = properties.getProperty(KEYCHAIN_PASS_KEY);
        if (remoteKeychainPass == null || remoteKeychainPass.isEmpty()) {
            throw new ConfigurationValidationException(KEYCHAIN_PASS_KEY, "Please enter a remote Keychain.pass value.");
        }
        String remoteKeychainLocktimeout = properties.getProperty(KEYCHAIN_LOCKTIMEOUT_KEY);
        if (remoteKeychainLocktimeout == null || remoteKeychainLocktimeout.isEmpty()) {
            throw new ConfigurationValidationException(KEYCHAIN_LOCKTIMEOUT_KEY, "Wrong remote Keychain.locktimeout number, please enter a numeric value.");
        }
        if (!InputValidationHelper.isInteger(remoteKeychainLocktimeout)) {
            throw new ConfigurationValidationException(KEYCHAIN_LOCKTIMEOUT_KEY, "Please enter a Keychain.locktimeout number value.");
        }
        String remoteGradleRepositories = properties.getProperty(GRADLE_REPOSITORIES_KEY);
        if (remoteGradleRepositories == null || remoteGradleRepositories.isEmpty()) {
            throw new ConfigurationValidationException(GRADLE_REPOSITORIES_KEY, "Please enter a remote gradle repositories value.");
        }
    }

    public static void saveProperties(String saveFolder, Properties properties) throws IOException {
        String comment = " Supported keys and values:\n   host: address of the remote build server\n   port: port for ssh, defaults to 22\n   user: user on the remote build server\n   knownhosts: path to known_hosts file\n   identity: path to private key\n   keychain.name: name of keychain to unlock, defaults to 'moeremotebuild.keychain'\n   keychain.pass: password for keychain, defaults to ''\n   keychain.locktimeout: keychain lock timeout in seconds, defaults to 3600\n   gradle.repositories: repositories to be used when setting up the MOE SDK on the remote server, defaults to 'mavenCentral()'\n\nThe identity and knownhosts keys accept special parameters to access\n   environmental variables ($env$KEY), system properties ($sys$KEY)\n   and project properties ($proj$KEY).\n   Example: knownhosts=$sys$user.home/.ssh/known_hosts\n";
        File propertiesFile = new File(saveFolder, "moe.remotebuild.properties");
        if (propertiesFile.exists()) {
            propertiesFile.delete();
        }
        FileOutputStream out = new FileOutputStream(propertiesFile);
        properties.store(out, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String propertiesFilePath) throws Exception {
        FileInputStream inStream = null;
        try {
            File propertiesFile = new File(propertiesFilePath);
            inStream = new FileInputStream(propertiesFile);
            Properties property = new Properties();
            property.load(inStream);
            Properties properties = property;
            return properties;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

